/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.Processor;
import com.qq.tars.net.core.nio.Reactor;
import com.qq.tars.net.protocol.ProtocolFactory;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

public final class SelectorManager {
    private final AtomicLong sets = new AtomicLong(0L);
    private final Reactor[] reactorSet;
    private ProtocolFactory protocolFactory = null;
    private Executor threadPool = null;
    private Processor processor = null;
    private final int selectorPoolSize;
    private volatile boolean started;
    private boolean keepAlive;
    private boolean isTcpNoDelay = false;

    public SelectorManager(int selectorPoolSize, ProtocolFactory protocolFactory, Executor threadPool, Processor processor, boolean keepAlive, String reactorNamePrefix) throws IOException {
        this(selectorPoolSize, protocolFactory, threadPool, processor, keepAlive, reactorNamePrefix, false);
    }

    public SelectorManager(int selectorPoolSize, ProtocolFactory protocolFactory, Executor threadPool, Processor processor, boolean keepAlive, String reactorNamePrefix, boolean udpMode) throws IOException {
        if (udpMode) {
            selectorPoolSize = 1;
        }
        this.selectorPoolSize = selectorPoolSize;
        this.protocolFactory = protocolFactory;
        this.threadPool = threadPool;
        this.processor = processor;
        this.keepAlive = keepAlive;
        this.reactorSet = new Reactor[selectorPoolSize];
        for (int i = 0; i < this.reactorSet.length; ++i) {
            this.reactorSet[i] = new Reactor(this, reactorNamePrefix + "-" + protocolFactory.getClass().getSimpleName().toLowerCase() + "-" + String.valueOf(i), udpMode);
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        for (Reactor reactor : this.reactorSet) {
            reactor.start();
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Reactor reactor : this.reactorSet) {
            reactor.interrupt();
        }
    }

    public Reactor getReactor(int index) {
        if (index < 0 || index > this.reactorSet.length - 1) {
            throw new IllegalArgumentException("failed to get one reactor thread...");
        }
        return this.reactorSet[index];
    }

    public final Reactor nextReactor() {
        return this.reactorSet[(int)(this.sets.incrementAndGet() % (long)this.selectorPoolSize)];
    }

    public final Reactor getReactor(SelectionKey key) {
        Reactor reactor = null;
        Selector selector = key.selector();
        for (int i = 0; i < this.reactorSet.length; ++i) {
            reactor = this.reactorSet[i];
            if (reactor.selector != selector) continue;
            return reactor;
        }
        return null;
    }

    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public void setProtocolFactory(ProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public Executor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Executor threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.isTcpNoDelay;
    }

    public void setTcpNoDelay(boolean on) {
        this.isTcpNoDelay = on;
    }
}

