/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.stub;

import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.stream.StreamObserver;

public class FutureToObserverAdaptor<T>
implements StreamObserver<T> {
    private final CompletableFuture<T> future;

    public FutureToObserverAdaptor(CompletableFuture<T> future) {
        this.future = future;
    }

    @Override
    public void onNext(T data) {
        if (this.future.isDone() || this.future.isCancelled() || this.future.isCompletedExceptionally()) {
            throw new IllegalStateException("Too many response for unary method");
        }
        this.future.complete(data);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.future.isDone() || this.future.isCancelled() || this.future.isCompletedExceptionally()) {
            throw new IllegalStateException("Too many response for unary method");
        }
        this.future.completeExceptionally(throwable);
    }

    @Override
    public void onCompleted() {
        if (this.future.isDone() || this.future.isCancelled() || this.future.isCompletedExceptionally()) {
            return;
        }
        throw new IllegalStateException("Completed without value or exception ");
    }
}

