/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.call;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.PackableMethodFactory;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.TripleCustomerProtocolWapper;
import org.apache.dubbo.rpc.protocol.tri.call.AbstractServerCall;
import org.apache.dubbo.rpc.protocol.tri.stream.ServerStream;
import org.apache.dubbo.rpc.service.ServiceDescriptorInternalCache;

public class ReflectionAbstractServerCall
extends AbstractServerCall {
    private static final String PACKABLE_METHOD_CACHE = "PACKABLE_METHOD_CACHE";
    private final List<HeaderFilter> headerFilters;
    private List<MethodDescriptor> methodDescriptors;

    public ReflectionAbstractServerCall(Invoker<?> invoker, ServerStream serverStream, FrameworkModel frameworkModel, String acceptEncoding, String serviceName, String methodName, List<HeaderFilter> headerFilters, Executor executor) {
        super(invoker, serverStream, frameworkModel, ReflectionAbstractServerCall.getServiceDescriptor(invoker.getUrl()), acceptEncoding, serviceName, methodName, executor);
        this.headerFilters = headerFilters;
    }

    private static ServiceDescriptor getServiceDescriptor(URL url) {
        ProviderModel providerModel = (ProviderModel)url.getServiceModel();
        if (providerModel == null || providerModel.getServiceModel() == null) {
            return null;
        }
        return providerModel.getServiceModel();
    }

    private boolean isEcho(String methodName) {
        return "$echo".equals(methodName);
    }

    private boolean isGeneric(String methodName) {
        return "$invoke".equals(methodName) || "$invokeAsync".equals(methodName);
    }

    @Override
    public void startCall() {
        if (this.isGeneric(this.methodName)) {
            this.methodDescriptor = ServiceDescriptorInternalCache.genericService().getMethods(this.methodName).get(0);
        } else if (this.isEcho(this.methodName)) {
            this.methodDescriptor = ServiceDescriptorInternalCache.echoService().getMethods(this.methodName).get(0);
        } else {
            this.methodDescriptors = this.serviceDescriptor.getMethods(this.methodName);
            if (CollectionUtils.isEmpty(this.methodDescriptors)) {
                String lowerMethod = Character.toLowerCase(this.methodName.charAt(0)) + this.methodName.substring(1);
                this.methodDescriptors = this.serviceDescriptor.getMethods(lowerMethod);
            }
            if (CollectionUtils.isEmpty(this.methodDescriptors)) {
                this.responseErr(TriRpcStatus.UNIMPLEMENTED.withDescription("Method : " + this.methodName + " not found of service:" + this.serviceName));
                return;
            }
            if (this.methodDescriptors.size() == 1) {
                this.methodDescriptor = this.methodDescriptors.get(0);
            }
            if (this.methodDescriptors.size() == 2) {
                if (this.methodDescriptors.get(1).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    this.methodDescriptor = this.methodDescriptors.get(0);
                } else if (this.methodDescriptors.get(0).getRpcType() == MethodDescriptor.RpcType.SERVER_STREAM) {
                    this.methodDescriptor = this.methodDescriptors.get(1);
                }
            }
        }
        if (this.methodDescriptor != null) {
            this.loadPackableMethod(this.invoker.getUrl());
        }
        this.trySetListener();
        if (this.listener == null) {
            this.request(1);
        }
    }

    private void trySetListener() {
        if (this.listener != null) {
            return;
        }
        if (this.methodDescriptor == null) {
            return;
        }
        if (this.isClosed()) {
            return;
        }
        RpcInvocation invocation = this.buildInvocation(this.methodDescriptor);
        if (this.isClosed()) {
            return;
        }
        this.headerFilters.forEach(f -> f.invoke(this.invoker, invocation));
        if (this.isClosed()) {
            return;
        }
        this.listener = this.startInternalCall(invocation, this.methodDescriptor, this.invoker);
    }

    @Override
    protected Object parseSingleMessage(byte[] data) throws Exception {
        this.trySetMethodDescriptor(data);
        this.trySetListener();
        if (this.isClosed()) {
            return null;
        }
        ClassLoadUtil.switchContextLoader(this.invoker.getUrl().getServiceModel().getClassLoader());
        return this.packableMethod.getRequestUnpack().unpack(data);
    }

    private void trySetMethodDescriptor(byte[] data) {
        if (this.methodDescriptor != null) {
            return;
        }
        TripleCustomerProtocolWapper.TripleRequestWrapper request = TripleCustomerProtocolWapper.TripleRequestWrapper.parseFrom(data);
        Object[] paramTypes = request.getArgTypes().toArray(new String[request.getArgs().size()]);
        for (MethodDescriptor descriptor : this.methodDescriptors) {
            if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
            this.methodDescriptor = descriptor;
            break;
        }
        if (this.methodDescriptor == null) {
            this.close(TriRpcStatus.UNIMPLEMENTED.withDescription("Method :" + this.methodName + "[" + Arrays.toString(paramTypes) + "] not found of service:" + this.serviceDescriptor.getInterfaceName()), null);
            return;
        }
        this.loadPackableMethod(this.invoker.getUrl());
    }

    private void loadPackableMethod(URL url) {
        Map cacheMap = (Map)url.getServiceModel().getServiceMetadata().getAttributeMap().computeIfAbsent(PACKABLE_METHOD_CACHE, k -> new ConcurrentHashMap());
        this.packableMethod = cacheMap.computeIfAbsent(this.methodDescriptor, md -> this.frameworkModel.getExtensionLoader(PackableMethodFactory.class).getExtension(ConfigurationUtils.getGlobalConfiguration(url.getApplicationModel()).getString("dubbo.application.parameters.serialize.packable.factory", "default")).create(this.methodDescriptor, url, (String)this.requestMetadata.get(HttpHeaderNames.CONTENT_TYPE.toString())));
    }
}

