/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class CommandHelper {
    private final FrameworkModel frameworkModel;

    public CommandHelper(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public boolean hasCommand(String commandName) {
        BaseCommand command;
        try {
            command = this.frameworkModel.getExtensionLoader(BaseCommand.class).getExtension(commandName);
        }
        catch (Throwable throwable) {
            return false;
        }
        return command != null;
    }

    public List<Class<?>> getAllCommandClass() {
        Set<String> commandList = this.frameworkModel.getExtensionLoader(BaseCommand.class).getSupportedExtensions();
        ArrayList classes = new ArrayList();
        for (String commandName : commandList) {
            BaseCommand command = this.frameworkModel.getExtensionLoader(BaseCommand.class).getExtension(commandName);
            classes.add(command.getClass());
        }
        return classes;
    }

    public Class<?> getCommandClass(String commandName) {
        if (this.hasCommand(commandName)) {
            return this.frameworkModel.getExtensionLoader(BaseCommand.class).getExtension(commandName).getClass();
        }
        return null;
    }
}

