/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object getField(Object source, String fieldName) {
        try {
            Field f = source.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(source);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static Object invoke(Object source, String methodName, Object ... params) {
        try {
            Class[] classes = (Class[])Arrays.stream(params).map(param -> param != null ? param.getClass() : null).toArray(Class[]::new);
            for (Method method : source.getClass().getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !ReflectionUtils.matchParameters(method.getParameterTypes(), classes)) continue;
                method.setAccessible(true);
                return method.invoke(source, params);
            }
            throw new NoSuchMethodException("No method found with the specified name and parameter types");
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    private static boolean matchParameters(Class<?>[] methodParamTypes, Class<?>[] givenParamTypes) {
        if (methodParamTypes.length != givenParamTypes.length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (!(givenParamTypes[i] == null ? methodParamTypes[i].isPrimitive() : !methodParamTypes[i].isAssignableFrom(givenParamTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static List<Class<?>> getClassGenerics(Class<?> clazz, Class<?> interfaceClass) {
        Class<?> superclass;
        Type[] genericInterfaces;
        ArrayList generics = new ArrayList();
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !((rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()) instanceof Class) || !interfaceClass.isAssignableFrom((Class)rawType)) continue;
            for (Type actualTypeArgument : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(actualTypeArgument instanceof Class)) continue;
                generics.add((Class)actualTypeArgument);
            }
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
            for (Type actualTypeArgument : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                if (!(actualTypeArgument instanceof Class)) continue;
                generics.add((Class)actualTypeArgument);
            }
        }
        if ((superclass = clazz.getSuperclass()) != null) {
            generics.addAll(ReflectionUtils.getClassGenerics(superclass, interfaceClass));
        }
        return generics.stream().distinct().collect(Collectors.toList());
    }

    public static boolean match(Class<?> clazz, Class<?> interfaceClass, Object event) {
        List<Class<?>> eventTypes = ReflectionUtils.getClassGenerics(clazz, interfaceClass);
        return eventTypes.stream().allMatch(eventType -> eventType.isInstance(event));
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

