/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.SofaScheduledThreadPoolExecutor;
import com.alipay.sofa.common.utils.ClassUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class SofaThreadPoolTaskScheduler
extends ThreadPoolTaskScheduler {
    public static final String SIMPLE_CLASS_NAME = SofaThreadPoolTaskScheduler.class.getSimpleName();
    protected SofaScheduledThreadPoolExecutor sofaScheduledThreadPoolExecutor;
    protected String threadPoolName;
    protected String spaceName;
    protected long taskTimeout;
    protected long period;
    protected boolean sofaTracerTransmit;

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (this.threadPoolName == null) {
            this.threadPoolName = this.createName();
        }
        SofaScheduledThreadPoolExecutor executor = new SofaScheduledThreadPoolExecutor(this.getPoolSize(), threadFactory, rejectedExecutionHandler, this.threadPoolName, this.spaceName, this.taskTimeout, this.period, TimeUnit.MILLISECONDS);
        executor.setSofaTracerTransmit(this.sofaTracerTransmit);
        Boolean removeOnCancelPolicy = (Boolean)ClassUtil.getField("removeOnCancelPolicy", (Object)this);
        if (removeOnCancelPolicy.booleanValue()) {
            executor.setRemoveOnCancelPolicy(true);
        }
        ClassUtil.setField("scheduledExecutor", (Object)this, executor);
        this.sofaScheduledThreadPoolExecutor = executor;
        return executor;
    }

    protected String createName() {
        return SIMPLE_CLASS_NAME + String.format("%08x", ((Object)((Object)this)).hashCode());
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
        if (this.sofaScheduledThreadPoolExecutor != null) {
            this.sofaScheduledThreadPoolExecutor.updateThreadPoolName(threadPoolName);
        }
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
        if (this.sofaScheduledThreadPoolExecutor != null) {
            this.sofaScheduledThreadPoolExecutor.updatespaceName(spaceName);
        }
    }

    public long getTaskTimeout() {
        if (this.sofaScheduledThreadPoolExecutor == null) {
            return 0L;
        }
        return this.sofaScheduledThreadPoolExecutor.getConfig().getTaskTimeout();
    }

    public void setTaskTimeout(long taskTimeout) {
        this.taskTimeout = taskTimeout;
        if (this.sofaScheduledThreadPoolExecutor != null) {
            this.sofaScheduledThreadPoolExecutor.updateTaskTimeout(taskTimeout);
        }
    }

    public long getPeriod() {
        if (this.sofaScheduledThreadPoolExecutor == null) {
            return 0L;
        }
        return this.sofaScheduledThreadPoolExecutor.getConfig().getPeriod();
    }

    public void setPeriod(long period) {
        this.period = period;
        if (this.sofaScheduledThreadPoolExecutor != null) {
            this.sofaScheduledThreadPoolExecutor.updatePeriod(period);
        }
    }

    public TimeUnit getTimeUnit() {
        if (this.sofaScheduledThreadPoolExecutor == null) {
            return TimeUnit.MILLISECONDS;
        }
        return this.sofaScheduledThreadPoolExecutor.getConfig().getTimeUnit();
    }

    public void setSofaTracerTransmit(boolean sofaTracerTransmit) {
        this.sofaTracerTransmit = sofaTracerTransmit;
    }
}

