/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.config;

import com.alipay.sofa.common.config.ConfigKey;
import com.alipay.sofa.common.config.ConfigSource;
import com.alipay.sofa.common.config.DefaultConfigManager;
import com.alipay.sofa.common.config.ManagementListener;
import com.alipay.sofa.common.config.listener.LogConfigListener;
import com.alipay.sofa.common.config.source.SystemEnvConfigSource;
import com.alipay.sofa.common.config.source.SystemPropertyConfigSource;

public class SofaConfigs {
    private static final DefaultConfigManager INSTANCE;
    public static final String DEFAULT_EXPIRE_AFTER_SECOND = "5";
    public static final String DEFAULT_MAX_SIZE = "1000";

    public static <T> T getOrDefault(ConfigKey<T> key) {
        return INSTANCE.getOrDefault(key);
    }

    public static <T> T getOrCustomDefault(ConfigKey<T> key, T customDefault) {
        return INSTANCE.getOrCustomDefault(key, customDefault);
    }

    public static <T> T getOrCustomDefaultWithCache(ConfigKey<T> key, T customDefault) {
        return INSTANCE.getOrCustomDefaultWithCache(key, customDefault);
    }

    public static <T> T getOrDefaultWithCache(ConfigKey<T> key) {
        return INSTANCE.getOrDefaultWithCache(key);
    }

    public static void addConfigSource(ConfigSource configSource) {
        INSTANCE.addConfigSource(configSource);
    }

    public static void addConfigListener(ManagementListener configListener) {
        INSTANCE.addConfigListener(configListener);
    }

    public static DefaultConfigManager getInstance() {
        return INSTANCE;
    }

    static {
        long expireAfterSecond = Long.parseLong(System.getProperty("sofa.middleware.config.cache.expireTime", DEFAULT_EXPIRE_AFTER_SECOND));
        long maxSize = Long.parseLong(System.getProperty("sofa.middleware.config.cache.maxSize", DEFAULT_MAX_SIZE));
        INSTANCE = new DefaultConfigManager(expireAfterSecond, maxSize);
        INSTANCE.addConfigSource(new SystemPropertyConfigSource());
        INSTANCE.addConfigSource(new SystemEnvConfigSource());
        INSTANCE.addConfigListener(new LogConfigListener());
    }
}

