/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.security.SecureRandom;
import java.util.List;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class RandomLoadBalancer
extends AbstractLoadBalancer {
    private static final SecureRandom RANDOM = new SecureRandom();

    @Override
    public Upstream doSelect(List<Upstream> upstreamList, String ip) {
        int firstUpstreamWeight;
        int length = upstreamList.size();
        boolean sameWeight = true;
        int[] weights = new int[length];
        weights[0] = firstUpstreamWeight = this.getWeight(upstreamList.get(0));
        int totalWeight = firstUpstreamWeight;
        int halfLengthTotalWeight = 0;
        for (int i = 1; i < length; ++i) {
            int currentUpstreamWeight = this.getWeight(upstreamList.get(i));
            if (i <= (length + 1) / 2) {
                halfLengthTotalWeight = totalWeight;
            }
            weights[i] = currentUpstreamWeight;
            totalWeight += currentUpstreamWeight;
            if (!sameWeight || currentUpstreamWeight == firstUpstreamWeight) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            return this.random(totalWeight, halfLengthTotalWeight, weights, upstreamList);
        }
        return this.random(upstreamList);
    }

    private Upstream random(int totalWeight, int halfLengthTotalWeight, int[] weights, List<Upstream> upstreamList) {
        int offset = RANDOM.nextInt(totalWeight);
        int index = 0;
        int end = weights.length;
        if (offset >= halfLengthTotalWeight) {
            index = (weights.length + 1) / 2;
            offset -= halfLengthTotalWeight;
        } else {
            end = (weights.length + 1) / 2;
        }
        while (index < end) {
            if ((offset -= weights[index]) < 0) {
                return upstreamList.get(index);
            }
            ++index;
        }
        return this.random(upstreamList);
    }

    private Upstream random(List<Upstream> upstreamList) {
        return upstreamList.get(RANDOM.nextInt(upstreamList.size()));
    }
}

