/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import java.util.Map;

public class PollResult {
    private Map<String, Object> complete;
    private Map<String, Object> added;
    private Map<String, Object> changed;
    private Map<String, Object> deleted;
    private boolean incremental;
    private Object checkPoint;

    private PollResult() {
    }

    private PollResult(Map<String, Object> map) {
        this.complete = map;
        this.incremental = false;
    }

    private PollResult(Map<String, Object> map, Map<String, Object> map2, Map<String, Object> map3, Object object) {
        this.added = map;
        this.changed = map2;
        this.deleted = map3;
        this.checkPoint = object;
        this.incremental = true;
    }

    public static PollResult createFull(Map<String, Object> map) {
        return new PollResult(map);
    }

    public static PollResult createIncremental(Map<String, Object> map, Map<String, Object> map2, Map<String, Object> map3, Object object) {
        return new PollResult(map, map2, map3, object);
    }

    public final boolean hasChanges() {
        if (this.incremental) {
            return this.added != null && this.added.size() > 0 || this.changed != null && this.changed.size() > 0 || this.deleted != null && this.deleted.size() > 0;
        }
        return this.complete != null;
    }

    public final Map<String, Object> getComplete() {
        return this.complete;
    }

    public final Map<String, Object> getAdded() {
        return this.added;
    }

    public final Map<String, Object> getChanged() {
        return this.changed;
    }

    public final Map<String, Object> getDeleted() {
        return this.deleted;
    }

    public final boolean isIncremental() {
        return this.incremental;
    }

    public final Object getCheckPoint() {
        return this.checkPoint;
    }
}

