/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.loadbalance.picker;

import io.grpc.LoadBalancer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.convert.rule.impl.GrpcRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.grpc.context.GrpcConstants;
import org.apache.shenyu.plugin.grpc.loadbalance.SubChannelCopy;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.AbstractReadyPicker;
import org.apache.shenyu.plugin.grpc.loadbalance.picker.RandomPicker;

public class ShenyuPicker
extends AbstractReadyPicker {
    private final RandomPicker randomPicker;

    public ShenyuPicker(List<LoadBalancer.Subchannel> list) {
        super(list);
        this.randomPicker = new RandomPicker(list);
    }

    @Override
    protected SubChannelCopy pick(List<SubChannelCopy> list) {
        String grpcRuleId = (String)GrpcConstants.GRPC_RULE_ID.get();
        String selectorId = (String)GrpcConstants.GRPC_SELECTOR_ID.get();
        String remoteAddressIp = (String)GrpcConstants.GRPC_REMOTE_ADDRESS.get();
        GrpcRuleHandle cacheRuleHandle = ApplicationConfigCache.getInstance().getCacheRuleHandle(grpcRuleId);
        List<GrpcUpstream> grpcUpstreams = ApplicationConfigCache.getInstance().getGrpcUpstreamListCache(selectorId);
        if (CollectionUtils.isNotEmpty(grpcUpstreams)) {
            Upstream upstream = LoadBalancerFactory.selector(this.convertUpstreamList(grpcUpstreams), (String)cacheRuleHandle.getLoadBalance(), (String)remoteAddressIp);
            if (StringUtils.isBlank((CharSequence)upstream.getUrl()) && StringUtils.isBlank((CharSequence)upstream.getGroup()) && StringUtils.isBlank((CharSequence)upstream.getVersion())) {
                return this.randomPicker.pick(list);
            }
            List invokerGrays = list.stream().filter(each -> each.getUrl().equals(upstream.getUrl())).collect(Collectors.toList());
            return invokerGrays.stream().findFirst().orElse(null);
        }
        return this.randomPicker.pick(list);
    }

    private List<Upstream> convertUpstreamList(List<GrpcUpstream> grpcUpstreams) {
        return grpcUpstreams.stream().map(u -> Upstream.builder().protocol(u.getProtocol()).url(u.getUpstreamUrl()).weight(u.getWeight()).status(u.isStatus()).timestamp(u.getTimestamp()).build()).collect(Collectors.toList());
    }
}

