/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.grpclb;

import javax.annotation.Nullable;
import shade.polaris.com.google.common.base.Objects;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.Attributes;
import shade.polaris.io.grpc.ClientStreamTracer;
import shade.polaris.io.grpc.Metadata;
import shade.polaris.io.grpc.grpclb.GrpclbConstants;
import shade.polaris.io.grpc.internal.ForwardingClientStreamTracer;
import shade.polaris.io.grpc.internal.GrpcAttributes;

final class TokenAttachingTracerFactory
extends ClientStreamTracer.Factory {
    private static final ClientStreamTracer NOOP_TRACER = new ClientStreamTracer(){};
    @Nullable
    private final ClientStreamTracer.Factory delegate;

    TokenAttachingTracerFactory(@Nullable ClientStreamTracer.Factory delegate) {
        this.delegate = delegate;
    }

    @Override
    public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
        if (this.delegate == null) {
            return NOOP_TRACER;
        }
        final ClientStreamTracer clientStreamTracer = this.delegate.newClientStreamTracer(info, headers);
        class TokenPropagationTracer
        extends ForwardingClientStreamTracer {
            TokenPropagationTracer() {
            }

            @Override
            protected ClientStreamTracer delegate() {
                return clientStreamTracer;
            }

            @Override
            public void streamCreated(Attributes transportAttrs, Metadata headers) {
                Attributes eagAttrs = Preconditions.checkNotNull(transportAttrs.get(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS), "eagAttrs");
                String token = eagAttrs.get(GrpclbConstants.TOKEN_ATTRIBUTE_KEY);
                headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
                if (token != null) {
                    headers.put(GrpclbConstants.TOKEN_METADATA_KEY, token);
                }
                this.delegate().streamCreated(transportAttrs, headers);
            }
        }
        return new TokenPropagationTracer();
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TokenAttachingTracerFactory)) {
            return false;
        }
        return Objects.equal(this.delegate, ((TokenAttachingTracerFactory)other).delegate);
    }
}

