/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.server.rest;

import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.server.rest.SofaRestRequestHandler;
import com.alipay.sofa.rpc.server.rest.SofaResteasyDeployment;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class SofaNettyJaxrsServer
implements EmbeddedJaxrsServer {
    private final ServerConfig serverConfig;
    protected ServerBootstrap bootstrap = null;
    protected String hostname = null;
    protected int port = 8080;
    protected ResteasyDeployment deployment = new SofaResteasyDeployment();
    protected String root = "";
    protected SecurityDomain domain;
    private EventLoopGroup eventLoopGroup;
    private EventLoopGroup eventExecutor;
    private int ioWorkerCount = SystemInfo.getCpuCores() * 2;
    private int executorThreadCount = 16;
    private SSLContext sslContext;
    private int maxRequestSize = 0xA00000;
    private int backlog = 128;
    private List<ChannelHandler> channelHandlers = Collections.emptyList();
    private Map<ChannelOption, Object> channelOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> childChannelOptions = Collections.emptyMap();
    private List<ChannelHandler> httpChannelHandlers = Collections.emptyList();

    public SofaNettyJaxrsServer(ServerConfig serverConfig) {
        if (serverConfig == null) {
            throw new IllegalArgumentException("server config is null");
        }
        this.serverConfig = serverConfig;
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
    }

    public void setExecutorThreadCount(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers == null ? Collections.emptyList() : channelHandlers;
    }

    public void setHttpChannelHandlers(List<ChannelHandler> httpChannelHandlers) {
        this.httpChannelHandlers = httpChannelHandlers == null ? Collections.emptyList() : httpChannelHandlers;
    }

    public void setChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.channelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setChildChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.childChannelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public void setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && "/".equals(this.root)) {
            this.root = "";
        }
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
    }

    protected RequestDispatcher createRequestDispatcher() {
        return new RequestDispatcher((SynchronousDispatcher)this.deployment.getDispatcher(), this.deployment.getProviderFactory(), this.domain);
    }

    public void start() {
        boolean daemon = this.serverConfig.isDaemon();
        boolean isEpoll = this.serverConfig.isEpoll();
        NamedThreadFactory ioFactory = new NamedThreadFactory("SEV-REST-IO-" + this.port, daemon);
        NamedThreadFactory bizFactory = new NamedThreadFactory("SEV-REST-BIZ-" + this.port, daemon);
        this.eventLoopGroup = isEpoll ? new EpollEventLoopGroup(this.ioWorkerCount, (ThreadFactory)ioFactory) : new NioEventLoopGroup(this.ioWorkerCount, (ThreadFactory)ioFactory);
        this.eventExecutor = isEpoll ? new EpollEventLoopGroup(this.executorThreadCount, (ThreadFactory)bizFactory) : new NioEventLoopGroup(this.executorThreadCount, (ThreadFactory)bizFactory);
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.eventLoopGroup).channel(isEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler(this.createChannelInitializer()).option(ChannelOption.SO_BACKLOG, (Object)this.backlog)).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.serverConfig.isKeepAlive());
        for (Map.Entry<ChannelOption, Object> entry : this.channelOptions.entrySet()) {
            this.bootstrap.option(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ChannelOption, Object> entry : this.childChannelOptions.entrySet()) {
            this.bootstrap.childOption(entry.getKey(), entry.getValue());
        }
        InetSocketAddress socketAddress = null == this.hostname || this.hostname.isEmpty() ? new InetSocketAddress(this.port) : new InetSocketAddress(this.hostname, this.port);
        this.bootstrap.bind((SocketAddress)socketAddress).syncUninterruptibly();
    }

    private ChannelInitializer<SocketChannel> createChannelInitializer() {
        final RequestDispatcher dispatcher = this.createRequestDispatcher();
        if (this.sslContext == null) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    SofaNettyJaxrsServer.this.setupHandlers(ch, dispatcher, RestEasyHttpRequestDecoder.Protocol.HTTP);
                }
            };
        }
        final SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
                SofaNettyJaxrsServer.this.setupHandlers(ch, dispatcher, RestEasyHttpRequestDecoder.Protocol.HTTPS);
            }
        };
    }

    private void setupHandlers(SocketChannel ch, RequestDispatcher dispatcher, RestEasyHttpRequestDecoder.Protocol protocol) {
        ChannelPipeline channelPipeline = ch.pipeline();
        channelPipeline.addLast(this.channelHandlers.toArray(new ChannelHandler[this.channelHandlers.size()]));
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxRequestSize)});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        channelPipeline.addLast(this.httpChannelHandlers.toArray(new ChannelHandler[this.httpChannelHandlers.size()]));
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), this.root, protocol)});
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpResponseEncoder()});
        channelPipeline.addLast((EventExecutorGroup)this.eventExecutor, new ChannelHandler[]{new SofaRestRequestHandler(dispatcher)});
    }

    public void stop() {
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
            this.eventExecutor.shutdownGracefully().sync();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bootstrap = null;
    }
}

