/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;

public class ConfigUniqueNameGenerator {
    public static String getServiceName(AbstractInterfaceConfig interfaceConfig) {
        String uniqueId = interfaceConfig.getUniqueId();
        return interfaceConfig.getInterfaceId() + (StringUtils.isEmpty(uniqueId) ? "" : ":" + uniqueId);
    }

    public static String getUniqueName(AbstractInterfaceConfig interfaceConfig) {
        String version = interfaceConfig.getVersion();
        String uniqueId = interfaceConfig.getUniqueId();
        return interfaceConfig.getInterfaceId() + (StringUtils.isEmpty(version) ? ":1.0" : ":" + version) + (StringUtils.isEmpty(uniqueId) ? "" : ":" + uniqueId);
    }

    public static String getUniqueName(String interfaceId, String version, String uniqueId) {
        return interfaceId + (StringUtils.isEmpty(version) ? ":1.0" : ":" + version) + (StringUtils.isEmpty(uniqueId) ? "" : ":" + uniqueId);
    }

    public static String getUniqueNameProtocol(ProviderConfig providerConfig, String protocol) {
        if (StringUtils.isNotEmpty(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(providerConfig) + "@" + protocol;
        }
        return ConfigUniqueNameGenerator.getUniqueName(providerConfig);
    }

    public static String getInterfaceName(String uniqueName) {
        if (StringUtils.isEmpty(uniqueName)) {
            return uniqueName;
        }
        int index = uniqueName.indexOf(58);
        return index < 0 ? uniqueName : uniqueName.substring(0, index);
    }

    public static String getUniqueNameProtocol(ConsumerConfig consumerConfig) {
        return ConfigUniqueNameGenerator.getUniqueName(consumerConfig) + "@" + consumerConfig.getProtocol();
    }
}

