/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.utils;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtils {
    public static int THREAD_PRIORITY_NORMAL = 0;
    public static int THREAD_PRIORITY_HIGH = 10;
    public static int THREAD_PRIORITY_LOW = -10;

    public static ThreadPoolExecutor newFixedThreadPool(int corePoolSize) {
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    public static ThreadPoolExecutor newFixedThreadPool(int corePoolSize, BlockingQueue<Runnable> queue) {
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, queue);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int corePoolSize, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, queue, threadFactory);
    }

    public static ThreadPoolExecutor newFixedThreadPool(int corePoolSize, BlockingQueue<Runnable> queue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, queue, threadFactory, handler);
    }

    public static ThreadPoolExecutor newCachedThreadPool(int corePoolSize, int maximumPoolSize) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    public static ThreadPoolExecutor newCachedThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, queue);
    }

    public static ThreadPoolExecutor newCachedThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, queue, threadFactory);
    }

    public static ThreadPoolExecutor newCachedThreadPool(int corePoolSize, int maximumPoolSize, BlockingQueue<Runnable> queue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60000L, TimeUnit.MILLISECONDS, queue, threadFactory, handler);
    }

    public static ThreadPoolExecutor newCachedThreadPool(int corePoolSize, int maximumPoolSize, int keepAliveTime, BlockingQueue<Runnable> queue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, queue, threadFactory, handler);
    }

    public static BlockingQueue<Runnable> buildQueue(int size) {
        return ThreadPoolUtils.buildQueue(size, false);
    }

    public static BlockingQueue<Runnable> buildQueue(int size, boolean isPriority) {
        AbstractQueue queue = size == 0 ? new SynchronousQueue<Runnable>() : (isPriority ? (size < 0 ? new PriorityBlockingQueue() : new PriorityBlockingQueue(size)) : (size < 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(size)));
        return queue;
    }
}

