/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.lb.RandomLoadBalancer;
import com.alipay.sofa.rpc.common.SystemInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.ArrayList;
import java.util.List;

@Extension(value="localPref")
public class LocalPreferenceLoadBalancer
extends RandomLoadBalancer {
    public LocalPreferenceLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public ProviderInfo doSelect(SofaRequest invocation, List<ProviderInfo> providerInfos) {
        String localhost = SystemInfo.getLocalHost();
        if (StringUtils.isEmpty(localhost)) {
            return super.doSelect(invocation, providerInfos);
        }
        ArrayList<ProviderInfo> localProviderInfo = new ArrayList<ProviderInfo>();
        for (ProviderInfo providerInfo : providerInfos) {
            if (!localhost.equals(providerInfo.getHost())) continue;
            localProviderInfo.add(providerInfo);
        }
        if (CommonUtils.isNotEmpty(localProviderInfo)) {
            return super.doSelect(invocation, localProviderInfo);
        }
        return super.doSelect(invocation, providerInfos);
    }
}

