/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Date;
import java.util.List;
import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.mapper.OperationRecordLogMapper;
import org.apache.shenyu.admin.model.entity.OperationRecordLog;
import org.apache.shenyu.admin.model.query.RecordLogQueryCondition;
import org.apache.shenyu.admin.service.OperationRecordLogService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.stereotype.Service;

@Service
public class OperationRecordLogServiceImpl
implements OperationRecordLogService {
    private final OperationRecordLogMapper recordLogMapper;
    private final DashboardProperties dashboardProperties;

    public OperationRecordLogServiceImpl(OperationRecordLogMapper recordLogMapper, DashboardProperties dashboardProperties) {
        this.recordLogMapper = recordLogMapper;
        this.dashboardProperties = dashboardProperties;
    }

    @Override
    public void doConditionPreProcessing(RecordLogQueryCondition condition) {
        condition.init();
        Assert.isTrue(condition.getEndTime().getTime() > condition.getStartTime().getTime(), "end time must be greater than start time");
        if (!SessionUtil.isAdmin()) {
            condition.setUsername(SessionUtil.visitorName());
        }
    }

    @Override
    public List<OperationRecordLog> searchByCondition(RecordLogQueryCondition condition) {
        return this.recordLogMapper.selectByCondition(condition);
    }

    @Override
    public List<OperationRecordLog> list() {
        if (SessionUtil.isAdmin()) {
            return this.recordLogMapper.selectLimit(null, this.dashboardProperties.getRecordLogLimit());
        }
        return this.recordLogMapper.selectLimit(SessionUtil.visitorName(), this.dashboardProperties.getRecordLogLimit());
    }

    @Override
    public boolean cleanHistory(Date date) {
        long supportMaxTime = System.currentTimeMillis() - (long)this.dashboardProperties.getOnlyCleanDays().intValue() * 86400000L;
        Assert.isTrue(date.getTime() < supportMaxTime, String.format("Only supports cleaning data older than %d days", this.dashboardProperties.getOnlyCleanDays()));
        return this.recordLogMapper.deleteByBefore(date) > 0;
    }
}

