/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.disruptor.RegisterClientServerDisruptorPublisher;
import org.apache.shenyu.admin.mapper.ApiMapper;
import org.apache.shenyu.admin.mapper.TagMapper;
import org.apache.shenyu.admin.mapper.TagRelationMapper;
import org.apache.shenyu.admin.model.bean.DocItem;
import org.apache.shenyu.admin.model.dto.ApiDTO;
import org.apache.shenyu.admin.model.entity.ApiDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.entity.TagDO;
import org.apache.shenyu.admin.model.entity.TagRelationDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ApiQuery;
import org.apache.shenyu.admin.model.query.RuleQueryCondition;
import org.apache.shenyu.admin.model.query.TagRelationQuery;
import org.apache.shenyu.admin.model.vo.ApiVO;
import org.apache.shenyu.admin.model.vo.RuleVO;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.ApiService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.enums.ApiSourceEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiServiceImpl
implements ApiService {
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final MetaDataService metaDataService;
    private final ApiMapper apiMapper;
    private final TagRelationMapper tagRelationMapper;
    private final TagMapper tagMapper;

    public ApiServiceImpl(SelectorService selectorService, RuleService ruleService, MetaDataService metaDataService, ApiMapper apiMapper, TagRelationMapper tagRelationMapper, TagMapper tagMapper) {
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.metaDataService = metaDataService;
        this.apiMapper = apiMapper;
        this.tagRelationMapper = tagRelationMapper;
        this.tagMapper = tagMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createOrUpdate(ApiDTO apiDTO) {
        return StringUtils.isBlank((CharSequence)apiDTO.getId()) ? this.create(apiDTO) : this.update(apiDTO);
    }

    private String update(ApiDTO apiDTO) {
        ApiDO apiDO = ApiDO.buildApiDO(apiDTO);
        int updateRows = this.apiMapper.updateByPrimaryKeySelective(apiDO);
        if (updateRows > 0 && CollectionUtils.isNotEmpty(apiDTO.getTagIds())) {
            List<String> tagIds = apiDTO.getTagIds();
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            List<TagRelationDO> tags = tagIds.stream().map(tagId -> TagRelationDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).apiId(apiDO.getId()).tagId((String)tagId).dateCreated(currentTime).dateUpdated(currentTime).build()).collect(Collectors.toList());
            this.tagRelationMapper.deleteByApiId(apiDO.getId());
            this.tagRelationMapper.batchInsert(tags);
        }
        return "update success";
    }

    private String create(ApiDTO apiDTO) {
        ApiDO apiDO = ApiDO.buildApiDO(apiDTO);
        int insertRows = this.apiMapper.insertSelective(apiDO);
        if (insertRows > 0 && CollectionUtils.isNotEmpty(apiDTO.getTagIds())) {
            List<String> tagIds = apiDTO.getTagIds();
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            List<TagRelationDO> tags = tagIds.stream().map(tagId -> TagRelationDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).apiId(apiDO.getId()).tagId((String)tagId).dateCreated(currentTime).dateUpdated(currentTime).build()).collect(Collectors.toList());
            this.tagRelationMapper.batchInsert(tags);
        }
        return "create success";
    }

    private void removeRegister(ApiDO apiDO) {
        String path = apiDO.getApiPath();
        RuleQueryCondition condition = new RuleQueryCondition();
        condition.setKeyword(path);
        List rules = this.ruleService.searchByCondition(condition);
        if (CollectionUtils.isNotEmpty(rules)) {
            this.ruleService.deleteByIdsAndNamespaceId(rules.stream().map(RuleVO::getId).distinct().collect(Collectors.toList()), "649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        List<SelectorDO> selectorDOList = this.selectorService.findByNameAndPluginNamesAndNamespaceId(apiDO.getContextPath(), PluginEnum.getUpstreamNames(), "649330b6-c2d7-4edc-be8e-8a54df9eb385");
        ArrayList selectorIds = Lists.newArrayList();
        Optional.ofNullable(selectorDOList).orElseGet(ArrayList::new).stream().forEach(selectorDO -> {
            String selectorId = selectorDO.getId();
            List<RuleData> data = this.ruleService.findBySelectorId(selectorId);
            if (CollectionUtils.isEmpty(data)) {
                selectorIds.add(selectorId);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)selectorIds)) {
            this.selectorService.deleteByNamespaceId(selectorIds, "649330b6-c2d7-4edc-be8e-8a54df9eb385");
        }
        Optional.ofNullable(this.metaDataService.findByPathAndNamespaceId(path, "649330b6-c2d7-4edc-be8e-8a54df9eb385")).ifPresent(metaDataDO -> this.metaDataService.deleteByIdsAndNamespaceId(Lists.newArrayList((Object[])new String[]{metaDataDO.getId()}), "649330b6-c2d7-4edc-be8e-8a54df9eb385"));
    }

    private void register(ApiDO apiDO) {
        ApiDocRegisterDTO.ApiExt ext = (ApiDocRegisterDTO.ApiExt)GsonUtils.getInstance().fromJson(apiDO.getExt(), ApiDocRegisterDTO.ApiExt.class);
        RegisterClientServerDisruptorPublisher publisher = RegisterClientServerDisruptorPublisher.getInstance();
        String contextPath = apiDO.getContextPath();
        String path = apiDO.getApiPath();
        String appName = contextPath.substring(1);
        String host = ext.getHost();
        Integer port = ext.getPort();
        publisher.publish((DataTypeParent)MetaDataRegisterDTO.builder().addPrefixed(ext.isAddPrefixed()).appName(appName).serviceName(ext.getServiceName()).methodName(ext.getMethodName()).contextPath(contextPath).host(host).port(port).path(path).ruleName(path).pathDesc(apiDO.getApiDesc()).parameterTypes(ext.getParameterTypes()).rpcExt(ext.getRpcExt()).rpcType(apiDO.getRpcType()).enabled(true).build());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        List<ApiDO> apis = this.apiMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(apis)) {
            return "The api(s) does not exist\uff01";
        }
        List apiIds = ListUtil.map(apis, ApiDO::getId);
        int deleteRows = this.apiMapper.deleteByIds(apiIds);
        if (deleteRows > 0) {
            this.tagRelationMapper.deleteByApiIds(apiIds);
        }
        return "";
    }

    @Override
    public ApiVO findById(String id) {
        return Optional.ofNullable(this.apiMapper.selectByPrimaryKey(id)).map(item -> {
            ApiVO apiVO;
            List<TagRelationDO> tagRelations = this.tagRelationMapper.selectByQuery(TagRelationQuery.builder().apiId(item.getId()).build());
            List<String> tagIds = tagRelations.stream().map(TagRelationDO::getTagId).collect(Collectors.toList());
            List<Object> tagVOs = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(tagIds)) {
                List<TagDO> tagDOS = this.tagMapper.selectByIds(tagIds);
                tagVOs = tagDOS.stream().map(TagVO::buildTagVO).collect(Collectors.toList());
            }
            if ((apiVO = ApiVO.buildApiVO(item, tagVOs)).getApiSource().equals(ApiSourceEnum.SWAGGER.getValue())) {
                DocItem docItem = (DocItem)JsonUtils.jsonToObject((String)apiVO.getDocument(), DocItem.class);
                apiVO.setRequestHeaders(docItem.getRequestHeaders());
                apiVO.setRequestParameters(docItem.getRequestParameters());
                apiVO.setResponseParameters(docItem.getResponseParameters());
                apiVO.setBizCustomCodeList(docItem.getBizCodeList());
            }
            return apiVO;
        }).orElse(null);
    }

    @Override
    public CommonPager<ApiVO> listByPage(ApiQuery apiQuery) {
        return PageResultUtils.result(apiQuery.getPageParameter(), () -> this.apiMapper.selectByQuery(apiQuery).stream().map(item -> {
            List<TagRelationDO> tagRelations = this.tagRelationMapper.selectByQuery(TagRelationQuery.builder().apiId(item.getId()).build());
            List<String> tagIds = tagRelations.stream().map(TagRelationDO::getTagId).collect(Collectors.toList());
            List<Object> tagVOS = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(tagIds)) {
                List<TagDO> tagDOS = this.tagMapper.selectByIds(tagIds);
                tagVOS = tagDOS.stream().map(TagVO::buildTagVO).collect(Collectors.toList());
            }
            return ApiVO.buildApiVO(item, tagVOS);
        }).collect(Collectors.toList()));
    }

    @Override
    public int deleteByApiPathHttpMethodRpcType(String apiPath, Integer httpMethod, String rpcType) {
        List<ApiDO> apiDOs = this.apiMapper.selectByApiPathHttpMethodRpcType(apiPath, httpMethod, rpcType);
        if (CollectionUtils.isNotEmpty(apiDOs)) {
            List apiIds = ListUtil.map(apiDOs, ApiDO::getId);
            int deleteRows = this.apiMapper.deleteByIds(apiIds);
            if (deleteRows > 0) {
                this.tagRelationMapper.deleteByApiIds(apiIds);
            }
            return deleteRows;
        }
        return 0;
    }

    @Override
    public String offlineByContextPath(String contextPath) {
        this.apiMapper.updateOfflineByContextPath(contextPath);
        return "success";
    }
}

