/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.dict;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;

public class DictChangedEvent
extends AdminDataModelChangedEvent {
    public DictChangedEvent(ShenyuDictDO source, ShenyuDictDO before, EventTypeEnum type, String operator) {
        super(source, before, type, operator);
    }

    @Override
    public String buildContext() {
        ShenyuDictDO after = (ShenyuDictDO)this.getAfter();
        if (Objects.isNull(this.getBefore())) {
            return String.format("the dict [%s] is %s", after.getDictName(), StringUtils.lowerCase((String)this.getType().getType().toString()));
        }
        return String.format("the dict [%s] is %s : %s", after.getDictName(), StringUtils.lowerCase((String)this.getType().getType().toString()), this.contrast());
    }

    private String contrast() {
        ShenyuDictDO before = (ShenyuDictDO)this.getBefore();
        Objects.requireNonNull(before);
        ShenyuDictDO after = (ShenyuDictDO)this.getAfter();
        Objects.requireNonNull(after);
        if (Objects.equals(before, after)) {
            return "it no change";
        }
        StringBuilder builder = new StringBuilder();
        if (!Objects.equals(before.getDictName(), after.getDictName())) {
            builder.append(String.format("name[%s => %s] ", before.getDictName(), after.getDictName()));
        }
        if (!Objects.equals(before.getDictValue(), after.getDictValue())) {
            builder.append(String.format("value[%s => %s] ", before.getDictValue(), after.getDictValue()));
        }
        if (!Objects.equals(before.getDesc(), after.getDesc())) {
            builder.append(String.format("desc[%s => %s] ", before.getDesc(), after.getDesc()));
        }
        if (!Objects.equals(before.getType(), after.getType())) {
            builder.append(String.format("type[%s => %s] ", before.getType(), after.getType()));
        }
        if (!Objects.equals(before.getEnabled(), after.getEnabled())) {
            builder.append(String.format("enable[%s => %s] ", before.getEnabled(), after.getEnabled()));
        }
        if (!Objects.equals(before.getSort(), after.getSort())) {
            builder.append(String.format("sort[%s => %s] ", before.getSort(), after.getSort()));
        }
        return builder.toString();
    }

    @Override
    public String eventName() {
        return "dict";
    }
}

