/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event.dict;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.apache.shenyu.admin.model.event.dict.BatchDictChangedEvent;
import org.apache.shenyu.common.utils.ListUtil;

public class BatchDictDeletedEvent
extends BatchDictChangedEvent {
    private final List<String> deletedIds;

    public BatchDictDeletedEvent(Collection<ShenyuDictDO> source, String operator) {
        super(source, (Collection<ShenyuDictDO>)null, EventTypeEnum.DICT_DELETE, operator);
        this.deletedIds = ListUtil.map(source, BaseDO::getId);
    }

    @Override
    public String buildContext() {
        String data = ((Collection)this.getSource()).stream().map(s -> ((ShenyuDictDO)s).getDictName()).collect(Collectors.joining(","));
        return String.format("the dict[%s] is %s", data, StringUtils.lowerCase((String)this.getType().getType().toString()));
    }

    public List<String> getDeletedIds() {
        return this.deletedIds;
    }
}

