/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mode.cluster.impl.jdbc;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.ClusterProperties;
import org.apache.shenyu.admin.mode.cluster.impl.jdbc.mapper.ClusterMasterMapper;
import org.apache.shenyu.admin.mode.cluster.service.ClusterSelectMasterService;
import org.apache.shenyu.admin.model.dto.ClusterMasterDTO;
import org.apache.shenyu.admin.model.entity.ClusterMasterDO;
import org.apache.shenyu.admin.transfer.ClusterMasterTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.jdbc.lock.JdbcLockRegistry;

public class ClusterSelectMasterServiceJdbcImpl
implements ClusterSelectMasterService {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSelectMasterServiceJdbcImpl.class);
    private static final String MASTER_LOCK_KEY = "shenyu_cluster_lock:master";
    private static final String MASTER_ID = "1";
    private final ClusterProperties clusterProperties;
    private final JdbcLockRegistry jdbcLockRegistry;
    private final ClusterMasterMapper clusterMasterMapper;
    private final Lock clusterMasterLock;
    private volatile boolean masterFlag;

    public ClusterSelectMasterServiceJdbcImpl(ClusterProperties clusterProperties, JdbcLockRegistry jdbcLockRegistry, ClusterMasterMapper clusterMasterMapper) {
        this.clusterProperties = clusterProperties;
        this.jdbcLockRegistry = jdbcLockRegistry;
        this.clusterMasterMapper = clusterMasterMapper;
        this.clusterMasterLock = jdbcLockRegistry.obtain((Object)MASTER_LOCK_KEY);
    }

    @Override
    public boolean selectMaster() {
        this.masterFlag = this.clusterMasterLock.tryLock();
        LOG.info("select master result: {}", (Object)this.masterFlag);
        return this.masterFlag;
    }

    @Override
    public boolean selectMaster(String masterHost, String masterPort, String contextPath) {
        this.masterFlag = this.clusterMasterLock.tryLock();
        if (this.masterFlag) {
            Timestamp now = Timestamp.valueOf(LocalDateTime.now());
            ClusterMasterDO masterDO = ClusterMasterDO.builder().id(MASTER_ID).masterHost(masterHost).masterPort(masterPort).contextPath(contextPath).dateCreated(now).dateUpdated(now).build();
            try {
                this.clusterMasterMapper.insert(masterDO);
            }
            catch (Exception e) {
                this.clusterMasterMapper.updateSelective(masterDO);
            }
        }
        return this.masterFlag;
    }

    @Override
    public boolean checkMasterStatus() throws IllegalStateException {
        if (this.masterFlag) {
            try {
                this.jdbcLockRegistry.renewLock((Object)MASTER_LOCK_KEY);
            }
            catch (IllegalStateException e) {
                this.masterFlag = false;
                throw e;
            }
        }
        return this.masterFlag;
    }

    @Override
    public boolean releaseMaster() {
        if (this.masterFlag) {
            this.clusterMasterLock.unlock();
            this.masterFlag = false;
        }
        return true;
    }

    @Override
    public boolean isMaster() {
        if (!this.clusterProperties.isEnabled()) {
            return true;
        }
        return this.masterFlag;
    }

    @Override
    public ClusterMasterDTO getMaster() {
        ClusterMasterDO masterDO = this.clusterMasterMapper.selectById(MASTER_ID);
        return Objects.isNull(masterDO) ? new ClusterMasterDTO() : ClusterMasterTransfer.INSTANCE.mapToDTO(masterDO);
    }

    @Override
    public String getMasterUrl() {
        ClusterMasterDO master = this.clusterMasterMapper.selectById(MASTER_ID);
        String contextPath = master.getContextPath();
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            return this.clusterProperties.getSchema() + "://" + master.getMasterHost() + ":" + master.getMasterPort();
        }
        if (contextPath.startsWith("/")) {
            return this.clusterProperties.getSchema() + "://" + master.getMasterHost() + ":" + master.getMasterPort() + contextPath;
        }
        return this.clusterProperties.getSchema() + "://" + master.getMasterHost() + ":" + master.getMasterPort() + "/" + contextPath;
    }
}

