/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.mapper.OperationRecordLogMapper;
import org.apache.shenyu.admin.model.entity.OperationRecordLog;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RecordLogDataChangedAdapterListener
implements DataChangedListener,
ApplicationListener<AdminDataModelChangedEvent> {
    private final OperationRecordLogMapper logMapper;

    public RecordLogDataChangedAdapterListener(OperationRecordLogMapper logMapper) {
        this.logMapper = logMapper;
    }

    public void onApplicationEvent(AdminDataModelChangedEvent event) {
        if (event.isConsumed()) {
            return;
        }
        OperationRecordLog log = new OperationRecordLog();
        log.setColor(event.getType().getColor());
        log.setContext(event.buildContext());
        log.setOperationTime(event.getDate());
        log.setOperationType(event.getType().getTypeName());
        log.setOperator(event.getOperator());
        this.logMapper.insert(log);
        event.consumed();
    }
}

