/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.config.global.APIConfig;
import com.tencent.polaris.api.config.provider.ServiceConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.DefaultRouterChainGroup;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.compose.RouterChainGroup;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceInstancesWrap;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.Services;
import com.tencent.polaris.api.rpc.Criteria;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.flow.GetResourcesInvoker;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;

public class BaseFlow {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFlow.class);

    public static Instance commonGetOneInstance(Extensions extensions, ServiceKey serviceKey, List<String> coreRouterNames, String lbPolicy, String protocol, String hashKey) {
        ServiceEventKey svcEventKey = new ServiceEventKey(serviceKey, ServiceEventKey.EventType.INSTANCE);
        LOG.debug("[ConnectionManager]start to discover service {}", (Object)svcEventKey);
        DefaultServiceEventKeysProvider provider = new DefaultServiceEventKeysProvider();
        provider.setSvcEventKey(svcEventKey);
        provider.setUseCache(true);
        DefaultFlowControlParam flowControlParam = new DefaultFlowControlParam();
        APIConfig apiConfig = extensions.getConfiguration().getGlobal().getAPI();
        flowControlParam.setTimeoutMs(apiConfig.getTimeout());
        flowControlParam.setMaxRetry(apiConfig.getMaxRetryTimes());
        flowControlParam.setRetryIntervalMs(apiConfig.getRetryInterval());
        ServiceInfo dstSvcInfo = new ServiceInfo();
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("protocol", protocol);
        dstSvcInfo.setMetadata(metadata);
        ServiceConfig serviceConfig = extensions.getConfiguration().getProvider().getService();
        RouteInfo routeInfo = new RouteInfo(null, null, dstSvcInfo, null, "", serviceConfig);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources(extensions, false, provider, flowControlParam);
        LOG.debug("[ConnectionManager]success to discover service {}", (Object)svcEventKey);
        ServiceInstances serviceInstances = resourcesResponse.getServiceInstances(svcEventKey);
        RouterChainGroup sysRouterChainGroup = extensions.getSysRouterChainGroup();
        List<ServiceRouter> coreRouters = Extensions.loadServiceRouters(coreRouterNames, extensions.getPlugins(), false);
        DefaultRouterChainGroup routerChainGroup = new DefaultRouterChainGroup(sysRouterChainGroup.getBeforeRouters(), coreRouters, sysRouterChainGroup.getAfterRouters());
        ServiceInstances instancesAfterRoute = BaseFlow.processServiceRouters(routeInfo, serviceInstances, routerChainGroup);
        LoadBalancer loadBalancer = (LoadBalancer)extensions.getPlugins().getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), lbPolicy);
        Criteria criteria = new Criteria();
        criteria.setHashKey(hashKey);
        return BaseFlow.processLoadBalance(loadBalancer, criteria, instancesAfterRoute);
    }

    public static ServiceInstances processServiceRouters(RouteInfo routeInfo, ServiceInstances dstInstances, RouterChainGroup routerChainGroup) throws PolarisException {
        if (null == dstInstances || CollectionUtils.isEmpty(dstInstances.getInstances())) {
            return dstInstances;
        }
        boolean processed = false;
        ServiceInstancesWrap serviceInstancesWrap = new ServiceInstancesWrap(dstInstances, dstInstances.getInstances(), dstInstances.getTotalWeight());
        if (BaseFlow.processRouterChain(routerChainGroup.getBeforeRouters(), routeInfo, serviceInstancesWrap)) {
            processed = true;
        }
        if (BaseFlow.processRouterChain(routerChainGroup.getCoreRouters(), routeInfo, serviceInstancesWrap)) {
            processed = true;
        }
        if (BaseFlow.processRouterChain(routerChainGroup.getAfterRouters(), routeInfo, serviceInstancesWrap)) {
            processed = true;
        }
        if (processed) {
            serviceInstancesWrap.reloadTotalWeight();
        }
        return serviceInstancesWrap;
    }

    private static boolean processRouterChain(List<ServiceRouter> routers, RouteInfo routeInfo, ServiceInstancesWrap serviceInstances) throws PolarisException {
        if (CollectionUtils.isEmpty(routers)) {
            return false;
        }
        boolean processed = false;
        block0: for (ServiceRouter router : routers) {
            if (CollectionUtils.isEmpty(serviceInstances.getInstances())) break;
            if (!router.enable(routeInfo, serviceInstances)) continue;
            processed = true;
            while (true) {
                RouteResult filteredInstances;
                RouteResult.NextRouterInfo nextRouterInfo;
                if ((nextRouterInfo = (filteredInstances = router.getFilteredInstances(routeInfo, serviceInstances)).getNextRouterInfo()).getState() == RouteResult.State.Next) {
                    serviceInstances.setInstances(filteredInstances.getInstances());
                    continue block0;
                }
                routeInfo.setNextRouterInfo(nextRouterInfo);
            }
        }
        return processed;
    }

    public static ResourcesResponse syncGetResources(Extensions extensions, boolean internalRequest, ServiceEventKeysProvider paramProvider, FlowControlParam controlParam) throws PolarisException {
        ResourcesResponse resourcesResponse;
        if (CollectionUtils.isEmpty(paramProvider.getSvcEventKeys()) && null == paramProvider.getSvcEventKey()) {
            return new ResourcesResponse();
        }
        long currentTime = System.currentTimeMillis();
        long deadline = currentTime + controlParam.getTimeoutMs();
        for (int retryTime = 0; currentTime < deadline && retryTime <= controlParam.getMaxRetry(); ++retryTime) {
            long diffTimeout = deadline - currentTime;
            try {
                GetResourcesInvoker invoker = new GetResourcesInvoker(paramProvider, extensions, internalRequest, paramProvider.isUseCache());
                return invoker.get(diffTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                currentTime = Utils.sleepUninterrupted(controlParam.getRetryIntervalMs());
                continue;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                LOG.error(String.format("syncGetInstances fail for services %s", paramProvider.toString()), cause);
                if (!(cause instanceof RetriableException)) break;
                currentTime = Utils.sleepUninterrupted(controlParam.getRetryIntervalMs());
                continue;
            }
            catch (TimeoutException e) {
                break;
            }
        }
        if (BaseFlow.readResourcesFromLocalCache(paramProvider, extensions, resourcesResponse = new ResourcesResponse())) {
            return resourcesResponse;
        }
        String errMsg = String.format("timeout while waiting response for svcEventKeys %s, svcEventKey %s", paramProvider.getSvcEventKeys(), paramProvider.getSvcEventKey());
        LOG.warn(errMsg);
        return new ResourcesResponse();
    }

    private static boolean readResourcesFromLocalCache(ServiceEventKeysProvider paramProvider, Extensions extensions, ResourcesResponse resourcesResponse) {
        LocalRegistry localRegistry = extensions.getLocalRegistry();
        if (null != paramProvider.getSvcEventKey() && BaseFlow.loadLocalResources(paramProvider.getSvcEventKey(), resourcesResponse, localRegistry)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(paramProvider.getSvcEventKeys())) {
            for (ServiceEventKey svcEventKey : paramProvider.getSvcEventKeys()) {
                if (!BaseFlow.loadLocalResources(svcEventKey, resourcesResponse, localRegistry)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean loadLocalResources(ServiceEventKey svcEventKey, ResourcesResponse resourcesResponse, LocalRegistry localRegistry) {
        ResourceFilter filter = new ResourceFilter(svcEventKey, false, true);
        if (svcEventKey.getEventType() == ServiceEventKey.EventType.INSTANCE) {
            ServiceInstances instances = localRegistry.getInstances(filter);
            if (instances.isInitialized()) {
                resourcesResponse.addServiceInstances(svcEventKey, instances);
                return false;
            }
            return true;
        }
        if (svcEventKey.getEventType() == ServiceEventKey.EventType.SERVICE) {
            Services services = localRegistry.getServices(filter);
            if (services.isInitialized()) {
                resourcesResponse.addServices(svcEventKey, services);
                return false;
            }
            return true;
        }
        ServiceRule serviceRule = localRegistry.getServiceRule(filter);
        if (serviceRule.isInitialized()) {
            resourcesResponse.addServiceRule(svcEventKey, serviceRule);
            return false;
        }
        return true;
    }

    public static Instance processLoadBalance(LoadBalancer loadBalancer, Criteria criteria, ServiceInstances dstInstances) throws PolarisException {
        Instance instance = loadBalancer.chooseInstance(criteria, dstInstances);
        if (null == instance) {
            throw new PolarisException(ErrorCode.INSTANCE_NOT_FOUND, String.format("no suitable instance for service %s after loadbanlancer %s", dstInstances.getNamespace() + "-" + dstInstances.getService(), loadBalancer.getName()));
        }
        return instance;
    }

    public static void buildFlowControlParam(RequestBaseEntity entity, Configuration config, FlowControlParam controlParam) {
        long timeoutMs = entity.getTimeoutMs();
        if (timeoutMs == 0L) {
            timeoutMs = config.getGlobal().getAPI().getTimeout();
        }
        controlParam.setTimeoutMs(timeoutMs);
        controlParam.setMaxRetry(config.getGlobal().getAPI().getMaxRetryTimes());
        controlParam.setRetryIntervalMs(config.getGlobal().getAPI().getRetryInterval());
    }
}

