/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.rpc;

import com.tencent.polaris.api.rpc.RequestBaseEntity;
import java.util.Map;
import java.util.Objects;

public class GetServicesRequest
extends RequestBaseEntity {
    private String namespace;
    private Map<String, String> metadata;

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return "GetServicesRequest{namespace='" + this.namespace + '\'' + ", metadata=" + this.metadata + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetServicesRequest)) {
            return false;
        }
        GetServicesRequest request = (GetServicesRequest)o;
        return Objects.equals(this.getNamespace(), request.getNamespace()) && Objects.equals(this.getMetadata(), request.getMetadata());
    }

    public int hashCode() {
        return Objects.hash(this.getNamespace(), this.getMetadata());
    }

    public static GetServicesRequestBuilder builder() {
        return new GetServicesRequestBuilder();
    }

    public static final class GetServicesRequestBuilder {
        private String service;
        private String namespace;
        private long timeoutMs;
        private Map<String, String> metadata;

        private GetServicesRequestBuilder() {
        }

        public GetServicesRequestBuilder service(String service) {
            this.service = service;
            return this;
        }

        public GetServicesRequestBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public GetServicesRequestBuilder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public GetServicesRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public GetServicesRequest build() {
            GetServicesRequest getServicesRequest = new GetServicesRequest();
            getServicesRequest.setService(this.service);
            getServicesRequest.setNamespace(this.namespace);
            getServicesRequest.setTimeoutMs(this.timeoutMs);
            getServicesRequest.setNamespace(this.namespace);
            getServicesRequest.setMetadata(this.metadata);
            return getServicesRequest;
        }
    }
}

