/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import kotlin.coroutines.Continuation;
import kotlinx.coroutines.reactor.MonoKt;
import org.springframework.core.KotlinDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class CoroutinesUtils {
    public static boolean isContinuation(Object candidate) {
        return CoroutinesUtils.isContinuationType(candidate.getClass());
    }

    public static boolean isContinuationType(Class<?> candidate) {
        return KotlinDetector.isKotlinPresent() && Continuation.class.isAssignableFrom(candidate);
    }

    @Nullable
    public static <T> T monoAwaitSingleOrNull(Mono<? extends T> source, Object continuation) {
        Assert.state((boolean)CoroutinesUtils.isContinuation(continuation), () -> "The 'continuation' must be an instance of 'kotlin.coroutines.Continuation', but it is: " + continuation.getClass());
        return (T)MonoKt.awaitSingleOrNull(source, (Continuation)((Continuation)continuation));
    }

    private CoroutinesUtils() {
    }
}

