/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.FilterOutput;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.ProtostuffOutput;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.WireFormat;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphProtostuffOutput
extends FilterOutput<ProtostuffOutput> {
    private final IdentityMap references;
    private int refCount = 0;

    public GraphProtostuffOutput(ProtostuffOutput output) {
        super((Output)output);
        this.references = new IdentityMap();
    }

    public GraphProtostuffOutput(ProtostuffOutput output, int initialCapacity) {
        super((Output)output);
        this.references = new IdentityMap(initialCapacity);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        ProtostuffOutput output = (ProtostuffOutput)this.output;
        if (this.references.shouldIncrement(this.refCount, value, output, fieldNumber)) {
            ++this.refCount;
            output.tail = output.sink.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)3), (WriteSession)output, output.tail);
            schema.writeTo((Output)this, value);
            output.tail = output.sink.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)4), (WriteSession)output, output.tail);
        }
    }

    private static final class IdentityMap {
        private static final int DEFAULT_CAPACITY = 32;
        private static final int MINIMUM_CAPACITY = 4;
        private static final int MAXIMUM_CAPACITY = 0x20000000;
        private transient Object[] table;
        private int size;
        private transient int threshold;

        public IdentityMap() {
            this.init(32);
        }

        public IdentityMap(int expectedMaxSize) {
            if (expectedMaxSize < 0) {
                throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
            }
            this.init(this.capacity(expectedMaxSize));
        }

        private int capacity(int expectedMaxSize) {
            int result;
            int minCapacity = 3 * expectedMaxSize / 2;
            if (minCapacity > 0x20000000 || minCapacity < 0) {
                result = 0x20000000;
            } else {
                for (result = 4; result < minCapacity; result <<= 1) {
                }
            }
            return result;
        }

        private void init(int initCapacity) {
            this.threshold = initCapacity * 2 / 3;
            this.table = new Object[2 * initCapacity];
        }

        private static int hash(Object x, int length) {
            int h = System.identityHashCode(x);
            return (h << 1) - (h << 8) & length - 1;
        }

        private static int nextKeyIndex(int i, int len) {
            return i + 2 < len ? i + 2 : 0;
        }

        public boolean shouldIncrement(int value, Object k, WriteSession output, int fieldNumber) throws IOException {
            Object item;
            Object[] tab = this.table;
            int len = tab.length;
            int i = IdentityMap.hash(k, len);
            while ((item = tab[i]) != null) {
                if (item == k) {
                    if (k instanceof Map.Entry && k.getClass().getName().startsWith("java.util")) {
                        return true;
                    }
                    output.tail = output.sink.writeVarInt32(((Integer)tab[i + 1]).intValue(), output, output.sink.writeVarInt32(WireFormat.makeTag((int)fieldNumber, (int)6), output, output.tail));
                    return false;
                }
                i = IdentityMap.nextKeyIndex(i, len);
            }
            tab[i] = k;
            tab[i + 1] = value;
            if (++this.size >= this.threshold) {
                this.resize(len);
            }
            return true;
        }

        private void resize(int newCapacity) {
            int newLength = newCapacity * 2;
            Object[] oldTable = this.table;
            int oldLength = oldTable.length;
            if (oldLength == 0x40000000) {
                if (this.threshold == 0x1FFFFFFF) {
                    throw new IllegalStateException("Capacity exhausted.");
                }
                this.threshold = 0x1FFFFFFF;
                return;
            }
            if (oldLength >= newLength) {
                return;
            }
            Object[] newTable = new Object[newLength];
            this.threshold = newLength / 3;
            for (int j = 0; j < oldLength; j += 2) {
                Object key = oldTable[j];
                if (key == null) continue;
                Object value = oldTable[j + 1];
                oldTable[j] = null;
                oldTable[j + 1] = null;
                int i = IdentityMap.hash(key, newLength);
                while (newTable[i] != null) {
                    i = IdentityMap.nextKeyIndex(i, newLength);
                }
                newTable[i] = key;
                newTable[i + 1] = value;
            }
            this.table = newTable;
        }
    }
}

