/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.ChatClientAttributes;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.DefaultChatClientBuilder;
import org.springframework.ai.chat.client.DefaultChatClientUtils;
import org.springframework.ai.chat.client.ResponseEntity;
import org.springframework.ai.chat.client.advisor.ChatModelCallAdvisor;
import org.springframework.ai.chat.client.advisor.ChatModelStreamAdvisor;
import org.springframework.ai.chat.client.advisor.DefaultAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.advisor.api.BaseAdvisorChain;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.client.observation.ChatClientObservationDocumentation;
import org.springframework.ai.chat.client.observation.DefaultChatClientObservationConvention;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.ai.converter.StructuredOutputConverter;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.template.TemplateRenderer;
import org.springframework.ai.template.st.StTemplateRenderer;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class DefaultChatClient
implements ChatClient {
    private static final ChatClientObservationConvention DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION = new DefaultChatClientObservationConvention();
    private static final TemplateRenderer DEFAULT_TEMPLATE_RENDERER = StTemplateRenderer.builder().build();
    private final DefaultChatClientRequestSpec defaultChatClientRequest;

    public DefaultChatClient(DefaultChatClientRequestSpec defaultChatClientRequest) {
        Assert.notNull((Object)defaultChatClientRequest, (String)"defaultChatClientRequest cannot be null");
        this.defaultChatClientRequest = defaultChatClientRequest;
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt() {
        return new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(String content) {
        Assert.hasText((String)content, (String)"content cannot be null or empty");
        return this.prompt(new Prompt(content));
    }

    @Override
    public ChatClient.ChatClientRequestSpec prompt(Prompt prompt) {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        DefaultChatClientRequestSpec spec = new DefaultChatClientRequestSpec(this.defaultChatClientRequest);
        if (prompt.getOptions() != null) {
            spec.options(prompt.getOptions());
        }
        if (prompt.getInstructions() != null) {
            spec.messages(prompt.getInstructions());
        }
        return spec;
    }

    @Override
    public ChatClient.Builder mutate() {
        return this.defaultChatClientRequest.mutate();
    }

    public static class DefaultChatClientRequestSpec
    implements ChatClient.ChatClientRequestSpec {
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention observationConvention;
        private final ChatModel chatModel;
        private final List<Media> media = new ArrayList<Media>();
        private final List<String> toolNames = new ArrayList<String>();
        private final List<ToolCallback> toolCallbacks = new ArrayList<ToolCallback>();
        private final List<Message> messages = new ArrayList<Message>();
        private final Map<String, Object> userParams = new HashMap<String, Object>();
        private final Map<String, Object> systemParams = new HashMap<String, Object>();
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> advisorParams = new HashMap<String, Object>();
        private final Map<String, Object> toolContext = new HashMap<String, Object>();
        private TemplateRenderer templateRenderer;
        @Nullable
        private String userText;
        @Nullable
        private String systemText;
        @Nullable
        private ChatOptions chatOptions;

        DefaultChatClientRequestSpec(DefaultChatClientRequestSpec ccr) {
            this(ccr.chatModel, ccr.userText, ccr.userParams, ccr.systemText, ccr.systemParams, ccr.toolCallbacks, ccr.messages, ccr.toolNames, ccr.media, ccr.chatOptions, ccr.advisors, ccr.advisorParams, ccr.observationRegistry, ccr.observationConvention, ccr.toolContext, ccr.templateRenderer);
        }

        public DefaultChatClientRequestSpec(ChatModel chatModel, @Nullable String userText, Map<String, Object> userParams, @Nullable String systemText, Map<String, Object> systemParams, List<ToolCallback> toolCallbacks, List<Message> messages, List<String> toolNames, List<Media> media, @Nullable ChatOptions chatOptions, List<Advisor> advisors, Map<String, Object> advisorParams, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention observationConvention, Map<String, Object> toolContext, @Nullable TemplateRenderer templateRenderer) {
            Assert.notNull((Object)chatModel, (String)"chatModel cannot be null");
            Assert.notNull(userParams, (String)"userParams cannot be null");
            Assert.notNull(systemParams, (String)"systemParams cannot be null");
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.notNull(toolNames, (String)"toolNames cannot be null");
            Assert.notNull(media, (String)"media cannot be null");
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.notNull(advisorParams, (String)"advisorParams cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            this.chatModel = chatModel;
            this.chatOptions = chatOptions != null ? chatOptions.copy() : (chatModel.getDefaultOptions() != null ? chatModel.getDefaultOptions().copy() : null);
            this.userText = userText;
            this.userParams.putAll(userParams);
            this.systemText = systemText;
            this.systemParams.putAll(systemParams);
            this.toolNames.addAll(toolNames);
            this.toolCallbacks.addAll(toolCallbacks);
            this.messages.addAll(messages);
            this.media.addAll(media);
            this.advisors.addAll(advisors);
            this.advisorParams.putAll(advisorParams);
            this.observationRegistry = observationRegistry;
            this.observationConvention = observationConvention != null ? observationConvention : DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION;
            this.toolContext.putAll(toolContext);
            this.templateRenderer = templateRenderer != null ? templateRenderer : DEFAULT_TEMPLATE_RENDERER;
        }

        @Nullable
        public String getUserText() {
            return this.userText;
        }

        public Map<String, Object> getUserParams() {
            return this.userParams;
        }

        @Nullable
        public String getSystemText() {
            return this.systemText;
        }

        public Map<String, Object> getSystemParams() {
            return this.systemParams;
        }

        @Nullable
        public ChatOptions getChatOptions() {
            return this.chatOptions;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getAdvisorParams() {
            return this.advisorParams;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public List<Media> getMedia() {
            return this.media;
        }

        public List<String> getToolNames() {
            return this.toolNames;
        }

        public List<ToolCallback> getToolCallbacks() {
            return this.toolCallbacks;
        }

        public Map<String, Object> getToolContext() {
            return this.toolContext;
        }

        public TemplateRenderer getTemplateRenderer() {
            return this.templateRenderer;
        }

        @Override
        public ChatClient.Builder mutate() {
            DefaultChatClientBuilder builder = (DefaultChatClientBuilder)ChatClient.builder(this.chatModel, this.observationRegistry, this.observationConvention).defaultTemplateRenderer(this.templateRenderer).defaultToolCallbacks(this.toolCallbacks).defaultToolContext(this.toolContext).defaultToolNames(StringUtils.toStringArray(this.toolNames));
            if (StringUtils.hasText((String)this.userText)) {
                builder.defaultUser(u -> u.text(this.userText).params(this.userParams).media(this.media.toArray(new Media[0])));
            }
            if (StringUtils.hasText((String)this.systemText)) {
                builder.defaultSystem(s -> s.text(this.systemText).params(this.systemParams));
            }
            if (this.chatOptions != null) {
                builder.defaultOptions(this.chatOptions);
            }
            builder.addMessages(this.messages);
            return builder;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Consumer<ChatClient.AdvisorSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultAdvisorSpec advisorSpec = new DefaultAdvisorSpec();
            consumer.accept(advisorSpec);
            this.advisorParams.putAll(advisorSpec.getParams());
            this.advisors.addAll(advisorSpec.getAdvisors());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(Arrays.asList(advisors));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(Message ... messages) {
            Assert.notNull((Object)messages, (String)"messages cannot be null");
            Assert.noNullElements((Object[])messages, (String)"messages cannot contain null elements");
            this.messages.addAll(List.of(messages));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec messages(List<Message> messages) {
            Assert.notNull(messages, (String)"messages cannot be null");
            Assert.noNullElements(messages, (String)"messages cannot contain null elements");
            this.messages.addAll(messages);
            return this;
        }

        @Override
        public <T extends ChatOptions> ChatClient.ChatClientRequestSpec options(T options) {
            Assert.notNull(options, (String)"options cannot be null");
            this.chatOptions = options;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolNames(String ... toolNames) {
            Assert.notNull((Object)toolNames, (String)"toolNames cannot be null");
            Assert.noNullElements((Object[])toolNames, (String)"toolNames cannot contain null elements");
            this.toolNames.addAll(List.of(toolNames));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(ToolCallback ... toolCallbacks) {
            Assert.notNull((Object)toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements((Object[])toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.toolCallbacks.addAll(List.of(toolCallbacks));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(List<ToolCallback> toolCallbacks) {
            Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
            Assert.noNullElements(toolCallbacks, (String)"toolCallbacks cannot contain null elements");
            this.toolCallbacks.addAll(toolCallbacks);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec tools(Object ... toolObjects) {
            Assert.notNull((Object)toolObjects, (String)"toolObjects cannot be null");
            Assert.noNullElements((Object[])toolObjects, (String)"toolObjects cannot contain null elements");
            this.toolCallbacks.addAll(Arrays.asList(ToolCallbacks.from((Object[])toolObjects)));
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolCallbacks(ToolCallbackProvider ... toolCallbackProviders) {
            Assert.notNull((Object)toolCallbackProviders, (String)"toolCallbackProviders cannot be null");
            Assert.noNullElements((Object[])toolCallbackProviders, (String)"toolCallbackProviders cannot contain null elements");
            for (ToolCallbackProvider toolCallbackProvider : toolCallbackProviders) {
                this.toolCallbacks.addAll(List.of(toolCallbackProvider.getToolCallbacks()));
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec toolContext(Map<String, Object> toolContext) {
            Assert.notNull(toolContext, (String)"toolContext cannot be null");
            Assert.noNullElements(toolContext.keySet(), (String)"toolContext keys cannot contain null elements");
            Assert.noNullElements(toolContext.values(), (String)"toolContext values cannot contain null elements");
            this.toolContext.putAll(toolContext);
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.systemText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.systemText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.system(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec system(Consumer<ChatClient.PromptSystemSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptSystemSpec systemSpec = new DefaultPromptSystemSpec();
            consumer.accept(systemSpec);
            this.systemText = StringUtils.hasText((String)systemSpec.text()) ? systemSpec.text() : this.systemText;
            this.systemParams.putAll(systemSpec.params());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.userText = text;
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.userText = text.getContentAsString(charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            return this.user(text, Charset.defaultCharset());
        }

        @Override
        public ChatClient.ChatClientRequestSpec user(Consumer<ChatClient.PromptUserSpec> consumer) {
            Assert.notNull(consumer, (String)"consumer cannot be null");
            DefaultPromptUserSpec us = new DefaultPromptUserSpec();
            consumer.accept(us);
            this.userText = StringUtils.hasText((String)us.text()) ? us.text() : this.userText;
            this.userParams.putAll(us.params());
            this.media.addAll(us.media());
            return this;
        }

        @Override
        public ChatClient.ChatClientRequestSpec templateRenderer(TemplateRenderer templateRenderer) {
            Assert.notNull((Object)templateRenderer, (String)"templateRenderer cannot be null");
            this.templateRenderer = templateRenderer;
            return this;
        }

        @Override
        public ChatClient.CallResponseSpec call() {
            BaseAdvisorChain advisorChain = this.buildAdvisorChain();
            return new DefaultCallResponseSpec(DefaultChatClientUtils.toChatClientRequest(this), advisorChain, this.observationRegistry, this.observationConvention);
        }

        @Override
        public ChatClient.StreamResponseSpec stream() {
            BaseAdvisorChain advisorChain = this.buildAdvisorChain();
            return new DefaultStreamResponseSpec(DefaultChatClientUtils.toChatClientRequest(this), advisorChain, this.observationRegistry, this.observationConvention);
        }

        private BaseAdvisorChain buildAdvisorChain() {
            this.advisors.add(ChatModelCallAdvisor.builder().chatModel(this.chatModel).build());
            this.advisors.add(ChatModelStreamAdvisor.builder().chatModel(this.chatModel).build());
            return DefaultAroundAdvisorChain.builder(this.observationRegistry).pushAll(this.advisors).templateRenderer(this.templateRenderer).build();
        }
    }

    public static class DefaultStreamResponseSpec
    implements ChatClient.StreamResponseSpec {
        private final ChatClientRequest request;
        private final BaseAdvisorChain advisorChain;
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention observationConvention;

        public DefaultStreamResponseSpec(ChatClientRequest chatClientRequest, BaseAdvisorChain advisorChain, ObservationRegistry observationRegistry, ChatClientObservationConvention observationConvention) {
            Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
            Assert.notNull((Object)advisorChain, (String)"advisorChain cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
            this.request = chatClientRequest;
            this.advisorChain = advisorChain;
            this.observationRegistry = observationRegistry;
            this.observationConvention = observationConvention;
        }

        private Flux<ChatClientResponse> doGetObservableFluxChatResponse(ChatClientRequest chatClientRequest) {
            return Flux.deferContextual(contextView -> {
                ChatClientObservationContext observationContext = ChatClientObservationContext.builder().request(chatClientRequest).advisors(this.advisorChain.getStreamAdvisors()).stream(true).build();
                Observation observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(this.observationConvention, DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
                observation.parentObservation((Observation)contextView.getOrDefault((Object)"micrometer.observation", null)).start();
                return this.advisorChain.nextStream(chatClientRequest).doOnError(arg_0 -> ((Observation)observation).error(arg_0)).doFinally(s -> observation.stop()).contextWrite(ctx -> ctx.put((Object)"micrometer.observation", (Object)observation));
            });
        }

        @Override
        public Flux<ChatClientResponse> chatClientResponse() {
            return this.doGetObservableFluxChatResponse(this.request);
        }

        @Override
        public Flux<ChatResponse> chatResponse() {
            return this.doGetObservableFluxChatResponse(this.request).mapNotNull(ChatClientResponse::chatResponse);
        }

        @Override
        public Flux<String> content() {
            return this.doGetObservableFluxChatResponse(this.request).mapNotNull(ChatClientResponse::chatResponse).map(r -> {
                if (r.getResult() == null || r.getResult().getOutput() == null || r.getResult().getOutput().getText() == null) {
                    return "";
                }
                return r.getResult().getOutput().getText();
            }).filter(StringUtils::hasLength);
        }
    }

    public static class DefaultCallResponseSpec
    implements ChatClient.CallResponseSpec {
        private final ChatClientRequest request;
        private final BaseAdvisorChain advisorChain;
        private final ObservationRegistry observationRegistry;
        private final ChatClientObservationConvention observationConvention;

        public DefaultCallResponseSpec(ChatClientRequest chatClientRequest, BaseAdvisorChain advisorChain, ObservationRegistry observationRegistry, ChatClientObservationConvention observationConvention) {
            Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest cannot be null");
            Assert.notNull((Object)advisorChain, (String)"advisorChain cannot be null");
            Assert.notNull((Object)observationRegistry, (String)"observationRegistry cannot be null");
            Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
            this.request = chatClientRequest;
            this.advisorChain = advisorChain;
            this.observationRegistry = observationRegistry;
            this.observationConvention = observationConvention;
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doResponseEntity((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        public <T> ResponseEntity<ChatResponse, T> responseEntity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doResponseEntity(structuredOutputConverter);
        }

        protected <T> ResponseEntity<ChatResponse, T> doResponseEntity(StructuredOutputConverter<T> outputConverter) {
            Assert.notNull(outputConverter, (String)"structuredOutputConverter cannot be null");
            ChatResponse chatResponse = this.doGetObservableChatClientResponse(this.request, outputConverter.getFormat()).chatResponse();
            String responseContent = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
            if (responseContent == null) {
                return new ResponseEntity<ChatResponse, Object>(chatResponse, null);
            }
            Object entity2 = outputConverter.convert((Object)responseContent);
            return new ResponseEntity<ChatResponse, Object>(chatResponse, entity2);
        }

        @Override
        @Nullable
        public <T> T entity(ParameterizedTypeReference<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            return this.doSingleWithBeanOutputConverter((StructuredOutputConverter<T>)new BeanOutputConverter(type));
        }

        @Override
        @Nullable
        public <T> T entity(StructuredOutputConverter<T> structuredOutputConverter) {
            Assert.notNull(structuredOutputConverter, (String)"structuredOutputConverter cannot be null");
            return this.doSingleWithBeanOutputConverter(structuredOutputConverter);
        }

        @Override
        @Nullable
        public <T> T entity(Class<T> type) {
            Assert.notNull(type, (String)"type cannot be null");
            BeanOutputConverter outputConverter = new BeanOutputConverter(type);
            return this.doSingleWithBeanOutputConverter((StructuredOutputConverter<T>)outputConverter);
        }

        @Nullable
        private <T> T doSingleWithBeanOutputConverter(StructuredOutputConverter<T> outputConverter) {
            ChatResponse chatResponse = this.doGetObservableChatClientResponse(this.request, outputConverter.getFormat()).chatResponse();
            String stringResponse = DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
            if (stringResponse == null) {
                return null;
            }
            return (T)outputConverter.convert((Object)stringResponse);
        }

        @Override
        public ChatClientResponse chatClientResponse() {
            return this.doGetObservableChatClientResponse(this.request);
        }

        @Override
        @Nullable
        public ChatResponse chatResponse() {
            return this.doGetObservableChatClientResponse(this.request).chatResponse();
        }

        @Override
        @Nullable
        public String content() {
            ChatResponse chatResponse = this.doGetObservableChatClientResponse(this.request).chatResponse();
            return DefaultCallResponseSpec.getContentFromChatResponse(chatResponse);
        }

        private ChatClientResponse doGetObservableChatClientResponse(ChatClientRequest chatClientRequest) {
            return this.doGetObservableChatClientResponse(chatClientRequest, null);
        }

        private ChatClientResponse doGetObservableChatClientResponse(ChatClientRequest chatClientRequest, @Nullable String outputFormat) {
            ChatClientObservationContext observationContext;
            Observation observation;
            ChatClientResponse chatClientResponse;
            if (outputFormat != null) {
                chatClientRequest.context().put(ChatClientAttributes.OUTPUT_FORMAT.getKey(), outputFormat);
            }
            return (chatClientResponse = (ChatClientResponse)(observation = ChatClientObservationDocumentation.AI_CHAT_CLIENT.observation(this.observationConvention, DEFAULT_CHAT_CLIENT_OBSERVATION_CONVENTION, () -> DefaultCallResponseSpec.lambda$doGetObservableChatClientResponse$0(observationContext = ChatClientObservationContext.builder().request(chatClientRequest).advisors(this.advisorChain.getCallAdvisors()).stream(false).format(outputFormat).build()), this.observationRegistry)).observe(() -> this.advisorChain.nextCall(chatClientRequest))) != null ? chatClientResponse : ChatClientResponse.builder().build();
        }

        @Nullable
        private static String getContentFromChatResponse(@Nullable ChatResponse chatResponse) {
            return Optional.ofNullable(chatResponse).map(ChatResponse::getResult).map(Generation::getOutput).map(AbstractMessage::getText).orElse(null);
        }

        private static /* synthetic */ ChatClientObservationContext lambda$doGetObservableChatClientResponse$0(ChatClientObservationContext observationContext) {
            return observationContext;
        }
    }

    public static class DefaultAdvisorSpec
    implements ChatClient.AdvisorSpec {
        private final List<Advisor> advisors = new ArrayList<Advisor>();
        private final Map<String, Object> params = new HashMap<String, Object>();

        @Override
        public ChatClient.AdvisorSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(Advisor ... advisors) {
            Assert.notNull((Object)advisors, (String)"advisors cannot be null");
            Assert.noNullElements((Object[])advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(List.of(advisors));
            return this;
        }

        @Override
        public ChatClient.AdvisorSpec advisors(List<Advisor> advisors) {
            Assert.notNull(advisors, (String)"advisors cannot be null");
            Assert.noNullElements(advisors, (String)"advisors cannot contain null elements");
            this.advisors.addAll(advisors);
            return this;
        }

        public List<Advisor> getAdvisors() {
            return this.advisors;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }
    }

    public static class DefaultPromptSystemSpec
    implements ChatClient.PromptSystemSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        @Nullable
        private String text;

        @Override
        public ChatClient.PromptSystemSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptSystemSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Nullable
        protected String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }
    }

    public static class DefaultPromptUserSpec
    implements ChatClient.PromptUserSpec {
        private final Map<String, Object> params = new HashMap<String, Object>();
        private final List<Media> media = new ArrayList<Media>();
        @Nullable
        private String text;

        @Override
        public ChatClient.PromptUserSpec media(Media ... media) {
            Assert.notNull((Object)media, (String)"media cannot be null");
            Assert.noNullElements((Object[])media, (String)"media cannot contain null elements");
            this.media.addAll(Arrays.asList(media));
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, URL url) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)url, (String)"url cannot be null");
            try {
                this.media.add(Media.builder().mimeType(mimeType).data(url.toURI()).build());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec media(MimeType mimeType, Resource resource) {
            Assert.notNull((Object)mimeType, (String)"mimeType cannot be null");
            Assert.notNull((Object)resource, (String)"resource cannot be null");
            this.media.add(Media.builder().mimeType(mimeType).data(resource).build());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(String text) {
            Assert.hasText((String)text, (String)"text cannot be null or empty");
            this.text = text;
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text, Charset charset) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            Assert.notNull((Object)charset, (String)"charset cannot be null");
            try {
                this.text(text.getContentAsString(charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec text(Resource text) {
            Assert.notNull((Object)text, (String)"text cannot be null");
            this.text(text, Charset.defaultCharset());
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec param(String key, Object value) {
            Assert.hasText((String)key, (String)"key cannot be null or empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.params.put(key, value);
            return this;
        }

        @Override
        public ChatClient.PromptUserSpec params(Map<String, Object> params) {
            Assert.notNull(params, (String)"params cannot be null");
            Assert.noNullElements(params.keySet(), (String)"param keys cannot contain null elements");
            Assert.noNullElements(params.values(), (String)"param values cannot contain null elements");
            this.params.putAll(params);
            return this;
        }

        @Nullable
        protected String text() {
            return this.text;
        }

        protected Map<String, Object> params() {
            return this.params;
        }

        protected List<Media> media() {
            return this.media;
        }
    }
}

