/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDataStreamFactory;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHousePipedOutputStream;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseResponseSummary;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.ClickHouseWriter;
import com.clickhouse.client.config.ClickHouseBufferingMode;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseDefaults;
import com.clickhouse.client.config.ClickHouseOption;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public interface ClickHouseClient
extends AutoCloseable {
    public static ClickHouseClientBuilder builder() {
        return new ClickHouseClientBuilder();
    }

    public static ExecutorService getExecutorService() {
        return ClickHouseClientBuilder.defaultExecutor;
    }

    public static ClickHouseOutputStream getRequestOutputStream(ClickHouseConfig config, OutputStream output, Runnable postCloseAction) {
        if (config == null) {
            return ClickHouseOutputStream.of(output, (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue(), ClickHouseCompression.NONE, postCloseAction);
        }
        return ClickHouseOutputStream.of(output, config.getWriteBufferSize(), config.getRequestCompressAlgorithm(), postCloseAction);
    }

    public static ClickHouseOutputStream getAsyncRequestOutputStream(ClickHouseConfig config, OutputStream output, Runnable postCloseAction) {
        if (config == null || !config.isAsync() || config.getRequestBuffering() == ClickHouseBufferingMode.RESOURCE_EFFICIENT) {
            return ClickHouseClient.getRequestOutputStream(config, output, postCloseAction);
        }
        CountDownLatch latch = new CountDownLatch(1);
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, () -> {
            try {
                latch.await();
                if (postCloseAction != null) {
                    postCloseAction.run();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Stopped waiting for writes", e);
            }
        });
        ClickHouseClient.submit(() -> {
            try (ClickHouseInputStream in = stream.getInputStream();
                 ClickHouseOutputStream out = ClickHouseClient.getRequestOutputStream(config, output, postCloseAction);){
                in.pipe(out);
            }
            finally {
                latch.countDown();
            }
            return null;
        });
        return stream;
    }

    public static ClickHouseInputStream getResponseInputStream(ClickHouseConfig config, InputStream input, Runnable postCloseAction) {
        if (config == null) {
            return ClickHouseInputStream.of(input, (Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue(), ClickHouseCompression.NONE, postCloseAction);
        }
        return ClickHouseInputStream.of(input, config.getReadBufferSize(), config.getResponseCompressAlgorithm(), postCloseAction);
    }

    public static ClickHouseInputStream getAsyncResponseInputStream(ClickHouseConfig config, InputStream input, Runnable postCloseAction) {
        ClickHouseInputStream wrappedInput;
        if (config == null || !config.isAsync() || config.getResponseBuffering() == ClickHouseBufferingMode.RESOURCE_EFFICIENT) {
            return ClickHouseClient.getResponseInputStream(config, input, postCloseAction);
        }
        ClickHousePipedOutputStream stream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, null);
        if (config.isResponseCompressed()) {
            ClickHousePipedOutputStream decompressedStream = ClickHouseDataStreamFactory.getInstance().createPipedOutputStream(config, null);
            wrappedInput = ClickHouseClient.getResponseInputStream(config, decompressedStream.getInputStream(), postCloseAction);
            ClickHouseClient.submit(() -> {
                try (ClickHouseInputStream in = ClickHouseInputStream.of(input, config.getReadBufferSize(), config.getResponseCompressAlgorithm(), null);
                     ClickHousePipedOutputStream out = decompressedStream;){
                    in.pipe(out);
                }
                return null;
            });
        } else {
            wrappedInput = ClickHouseClient.getResponseInputStream(config, input, postCloseAction);
        }
        ClickHouseClient.submit(() -> {
            try (ClickHouseInputStream in = wrappedInput;
                 ClickHousePipedOutputStream out = stream;){
                in.pipe(out);
            }
            return null;
        });
        return stream.getInputStream();
    }

    public static <T> CompletableFuture<T> submit(Callable<T> task) {
        try {
            return (Boolean)ClickHouseDefaults.ASYNC.getEffectiveDefaultValue() != false ? CompletableFuture.supplyAsync(() -> {
                try {
                    return task.call();
                }
                catch (ClickHouseException e) {
                    throw new CompletionException(e);
                }
                catch (CompletionException e) {
                    throw e;
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof CompletionException) {
                        throw (CompletionException)cause;
                    }
                    if (cause == null) {
                        cause = e;
                    }
                    throw new CompletionException(cause);
                }
            }, ClickHouseClient.getExecutorService()) : CompletableFuture.completedFuture(task.call());
        }
        catch (ClickHouseException e) {
            throw new CompletionException(e);
        }
        catch (CompletionException e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof CompletionException) {
                throw (CompletionException)cause;
            }
            if (cause == null) {
                cause = e;
            }
            throw new CompletionException(cause);
        }
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHouseFile file) {
        if (server == null || tableOrQuery == null || file == null) {
            throw new IllegalArgumentException("Non-null server, tableOrQuery, and file are required");
        }
        ClickHouseNode theServer = server.probe();
        String theQuery = tableOrQuery.trim();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.newInstance(theServer.getProtocol());){
                Object request = client.connect(theServer).output(file);
                if (theQuery.indexOf(32) < 0) {
                    ((ClickHouseRequest)request).table(theQuery);
                } else {
                    ((ClickHouseRequest)request).query(theQuery);
                }
                ClickHouseResponse response = ((ClickHouseRequest)request).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = response.getSummary();
                    if (response != null) {
                        response.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHouseFormat format, ClickHouseCompression compression, String file) {
        return ClickHouseClient.dump(server, tableOrQuery, ClickHouseFile.of(file, compression, 0, format));
    }

    public static CompletableFuture<ClickHouseResponseSummary> dump(ClickHouseNode server, String tableOrQuery, ClickHouseFormat format, ClickHouseCompression compression, OutputStream output) {
        if (server == null || tableOrQuery == null || output == null) {
            throw new IllegalArgumentException("Non-null server, tableOrQuery, and output are required");
        }
        ClickHouseNode theServer = server.probe();
        String theQuery = tableOrQuery.trim();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFile file) {
        if (server == null || table == null || file == null) {
            throw new IllegalArgumentException("Non-null server, table, and file are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.newInstance(theServer.getProtocol());){
                ClickHouseResponse response = ((ClickHouseRequest.Mutation)client.connect(theServer).write().table(table)).data(file).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = response.getSummary();
                    if (response != null) {
                        response.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, String file) {
        return ClickHouseClient.load(server, table, ClickHouseFile.of(file, compression, 0, format));
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, ClickHouseWriter writer) {
        if (server == null || table == null || writer == null) {
            throw new IllegalArgumentException("Non-null server, table, and writer are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> load(ClickHouseNode server, String table, ClickHouseFormat format, ClickHouseCompression compression, InputStream input) {
        if (server == null || table == null || input == null) {
            throw new IllegalArgumentException("Non-null server, table, and input are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public static ClickHouseClient newInstance(ClickHouseProtocol ... preferredProtocols) {
        return ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(null, preferredProtocols)).build();
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String ... more) {
        if (server == null || sql == null) {
            throw new IllegalArgumentException("Non-null server and sql are required");
        }
        ClickHouseNode theServer = server.probe();
        LinkedList<String> queries = new LinkedList<String>();
        queries.add(sql);
        if (more != null && more.length > 0) {
            for (String query : more) {
                queries.add(ClickHouseChecker.nonNull(query, "query"));
            }
        }
        return ClickHouseClient.submit(() -> {
            LinkedList<ClickHouseResponseSummary> list = new LinkedList<ClickHouseResponseSummary>();
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.connect(theServer).format(ClickHouseFormat.RowBinary);
                if (((Boolean)ClickHouseDefaults.AUTO_SESSION.getEffectiveDefaultValue()).booleanValue() && queries.size() > 1) {
                    ((ClickHouseRequest)request).session(((ClickHouseRequest)request).getManager().createSessionId(), false);
                }
                for (String query : queries) {
                    ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(query)).executeAndWait();
                    try {
                        list.add(resp.getSummary());
                    }
                    finally {
                        if (resp == null) continue;
                        resp.close();
                    }
                }
            }
            return list;
        });
    }

    public static CompletableFuture<ClickHouseResponseSummary> send(ClickHouseNode server, String sql, Map<String, String> params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql and parameters are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)client.connect(theServer).format(ClickHouseFormat.RowBinary)).query(sql)).params(params)).executeAndWait();
                try {
                    ClickHouseResponseSummary clickHouseResponseSummary = resp.getSummary();
                    if (resp != null) {
                        resp.close();
                    }
                    return clickHouseResponseSummary;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, List<ClickHouseColumn> columns, Object[] ... params) {
        int len;
        int n = len = columns == null ? 0 : columns.size();
        if (len == 0) {
            throw new IllegalArgumentException("Non-empty column list is required");
        }
        ClickHouseConfig config = new ClickHouseConfig(new ClickHouseConfig[0]);
        ClickHouseValue[] templates = new ClickHouseValue[len];
        int index = 0;
        for (ClickHouseColumn column : columns) {
            templates[index++] = ClickHouseValues.newValue(config, ClickHouseChecker.nonNull(column, "column"));
        }
        return ClickHouseClient.send(server, sql, templates, params);
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, ClickHouseValue[] templates, Object[] ... params) {
        int size;
        int len = templates != null ? templates.length : 0;
        int n = size = params != null ? params.length : 0;
        if (len == 0 || size == 0) {
            throw new IllegalArgumentException("Non-empty templates and parameters are required");
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(size);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = ((ClickHouseRequest)client.connect(theServer).format(ClickHouseFormat.RowBinary)).query(sql);
                for (int i = 0; i < size; ++i) {
                    int olen;
                    Object[] o = params[i];
                    String[] arr = new String[len];
                    int n = olen = o == null ? 0 : o.length;
                    for (int j = 0; j < len; ++j) {
                        ClickHouseValue v = templates[j];
                        arr[j] = j < olen ? (v != null ? v.update(o[j]).toSqlExpression() : ClickHouseValues.convertToSqlExpression(o[j])) : (v != null ? v.resetToNullOrEmpty().toSqlExpression() : "NULL");
                    }
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).params(arr)).executeAndWait();){
                        list.add(resp.getSummary());
                        continue;
                    }
                }
            }
            return list;
        });
    }

    public static CompletableFuture<List<ClickHouseResponseSummary>> send(ClickHouseNode server, String sql, String[][] params) {
        if (server == null || sql == null || params == null) {
            throw new IllegalArgumentException("Non-null server, sql, and parameters are required");
        }
        if (params.length == 0) {
            return ClickHouseClient.send(server, sql, new String[0]);
        }
        ClickHouseNode theServer = server.probe();
        return ClickHouseClient.submit(() -> {
            ArrayList<ClickHouseResponseSummary> list = new ArrayList<ClickHouseResponseSummary>(params.length);
            try (ClickHouseClient client = ClickHouseClient.builder().nodeSelector(ClickHouseNodeSelector.of(theServer.getProtocol(), new ClickHouseProtocol[0])).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false)).build();){
                Object request = client.connect(theServer).format(ClickHouseFormat.RowBinary);
                ClickHouseParameterizedQuery query = ClickHouseParameterizedQuery.of(((ClickHouseRequest)request).getConfig(), sql);
                StringBuilder builder = new StringBuilder();
                for (String[] p : params) {
                    builder.setLength(0);
                    query.apply(builder, p);
                    try (ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)request).query(builder.toString())).executeAndWait();){
                        list.add(resp.getSummary());
                    }
                }
            }
            return list;
        });
    }

    default public boolean accept(ClickHouseProtocol protocol) {
        return protocol == null || protocol == ClickHouseProtocol.ANY;
    }

    default public ClickHouseRequest<?> connect(String enpoints) {
        return this.connect(ClickHouseNodes.of(enpoints));
    }

    default public ClickHouseRequest<?> connect(ClickHouseNodes nodes) {
        return new ClickHouseRequest(this, ClickHouseChecker.nonNull(nodes, "Nodes"), null, nodes.template.config.getAllOptions(), false);
    }

    default public ClickHouseRequest<?> connect(ClickHouseNode node) {
        return new ClickHouseRequest(this, ClickHouseChecker.nonNull(node, "Node"), null, node.config.getAllOptions(), false);
    }

    default public ClickHouseRequest<?> connect(Function<ClickHouseNodeSelector, ClickHouseNode> nodeFunc) {
        return new ClickHouseRequest(this, ClickHouseChecker.nonNull(nodeFunc, "nodeFunc"), null, null, false);
    }

    public CompletableFuture<ClickHouseResponse> execute(ClickHouseRequest<?> var1);

    default public ClickHouseResponse executeAndWait(ClickHouseRequest<?> request) throws ClickHouseException {
        ClickHouseRequest<?> sealedRequest = request.seal();
        try {
            return this.execute(sealedRequest).get(sealedRequest.getConfig().getSocketTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ClickHouseException.forCancellation(e, sealedRequest.getServer());
        }
        catch (CancellationException e) {
            throw ClickHouseException.forCancellation(e, sealedRequest.getServer());
        }
        catch (UncheckedIOException | CompletionException | ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw cause instanceof ClickHouseException ? (ClickHouseException)cause : ClickHouseException.of(cause, sealedRequest.getServer());
        }
        catch (RuntimeException e) {
            throw ClickHouseException.of(e, sealedRequest.getServer());
        }
    }

    public ClickHouseConfig getConfig();

    default public Class<? extends ClickHouseOption> getOptionClass() {
        return null;
    }

    default public void init(ClickHouseConfig config) {
        ClickHouseChecker.nonNull(config, "configuration");
    }

    default public boolean ping(ClickHouseNode server, int timeout) {
        if (server != null) {
            if (timeout < 1) {
                timeout = server.config.getConnectionTimeout();
            }
            if (server.getProtocol() == ClickHouseProtocol.ANY) {
                server = ClickHouseNode.probe(server.getHost(), server.getPort(), timeout);
            }
            ClickHouseResponse resp = ((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)((ClickHouseRequest)this.connect(server).option(ClickHouseClientOption.ASYNC, Boolean.valueOf(false))).option(ClickHouseClientOption.CONNECTION_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.SOCKET_TIMEOUT, Integer.valueOf(timeout))).option(ClickHouseClientOption.BUFFER_SIZE, Integer.valueOf(8))).option(ClickHouseClientOption.MAX_QUEUED_BUFFERS, Integer.valueOf(1))).format(ClickHouseFormat.TabSeparated)).query("SELECT 1 FORMAT TabSeparated")).execute().get(timeout, TimeUnit.MILLISECONDS);
            try {
                boolean bl;
                boolean bl2 = bl = resp != null;
                if (resp != null) {
                    resp.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public void close();
}

