/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.jersey3;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.EurekaAccept;
import com.netflix.appinfo.EurekaClientIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.provider.DiscoveryJerseyProvider;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaClientFactoryBuilder;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey3.Jersey3ApplicationClient;
import com.netflix.discovery.shared.transport.jersey3.Jersey3EurekaIdentityHeaderFilter;
import com.netflix.discovery.util.DiscoveryBuildInfo;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.message.GZipEncoder;

public class Jersey3ApplicationClientFactory
implements TransportClientFactory {
    public static final String HTTP_X_DISCOVERY_ALLOW_REDIRECT = "X-Discovery-AllowRedirect";
    private static final String KEY_STORE_TYPE = "JKS";
    private final Client jersey3Client;
    private final MultivaluedMap<String, Object> additionalHeaders;

    public Jersey3ApplicationClientFactory(Client jersey3Client, MultivaluedMap<String, Object> additionalHeaders) {
        this.jersey3Client = jersey3Client;
        this.additionalHeaders = additionalHeaders;
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new Jersey3ApplicationClient(this.jersey3Client, endpoint.getServiceUrl(), this.additionalHeaders);
    }

    public void shutdown() {
        this.jersey3Client.close();
    }

    public static Jersey3ApplicationClientFactory create(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo, AbstractEurekaIdentity clientIdentity) {
        return Jersey3ApplicationClientFactory.create(clientConfig, additionalFilters, myInstanceInfo, clientIdentity, Optional.empty(), Optional.empty());
    }

    public static Jersey3ApplicationClientFactory create(EurekaClientConfig clientConfig, Collection<ClientRequestFilter> additionalFilters, InstanceInfo myInstanceInfo, AbstractEurekaIdentity clientIdentity, Optional<SSLContext> sslContext, Optional<HostnameVerifier> hostnameVerifier) {
        Jersey3ApplicationClientFactoryBuilder clientBuilder = Jersey3ApplicationClientFactory.newBuilder();
        clientBuilder.withAdditionalFilters(additionalFilters);
        clientBuilder.withMyInstanceInfo(myInstanceInfo);
        clientBuilder.withUserAgent("Java-EurekaClient");
        clientBuilder.withClientConfig(clientConfig);
        clientBuilder.withClientIdentity(clientIdentity);
        sslContext.ifPresent(arg_0 -> ((Jersey3ApplicationClientFactoryBuilder)clientBuilder).withSSLContext(arg_0));
        hostnameVerifier.ifPresent(arg_0 -> ((Jersey3ApplicationClientFactoryBuilder)clientBuilder).withHostnameVerifier(arg_0));
        if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            ((Jersey3ApplicationClientFactoryBuilder)clientBuilder.withClientName("DiscoveryClient-HTTPClient-System")).withSystemSSLConfiguration();
        } else if (clientConfig.getProxyHost() != null && clientConfig.getProxyPort() != null) {
            ((Jersey3ApplicationClientFactoryBuilder)clientBuilder.withClientName("Proxy-DiscoveryClient-HTTPClient")).withProxy(clientConfig.getProxyHost(), Integer.parseInt(clientConfig.getProxyPort()), clientConfig.getProxyUserName(), clientConfig.getProxyPassword());
        } else {
            clientBuilder.withClientName("DiscoveryClient-HTTPClient");
        }
        return clientBuilder.build();
    }

    public static Jersey3ApplicationClientFactoryBuilder newBuilder() {
        return new Jersey3ApplicationClientFactoryBuilder();
    }

    public static class Jersey3ApplicationClientFactoryBuilder
    extends EurekaClientFactoryBuilder<Jersey3ApplicationClientFactory, Jersey3ApplicationClientFactoryBuilder> {
        private List<Feature> features = new ArrayList<Feature>();
        private List<ClientRequestFilter> additionalFilters = new ArrayList<ClientRequestFilter>();

        public Jersey3ApplicationClientFactoryBuilder withFeature(Feature feature) {
            this.features.add(feature);
            return this;
        }

        Jersey3ApplicationClientFactoryBuilder withAdditionalFilters(Collection<ClientRequestFilter> additionalFilters) {
            if (additionalFilters != null) {
                this.additionalFilters.addAll(additionalFilters);
            }
            return this;
        }

        public Jersey3ApplicationClientFactory build() {
            ClientBuilder clientBuilder = ClientBuilder.newBuilder();
            ClientConfig clientConfig = new ClientConfig();
            for (ClientRequestFilter filter : this.additionalFilters) {
                clientConfig.register((Object)filter);
            }
            for (Feature feature : this.features) {
                clientConfig.register((Object)feature);
            }
            this.addProviders(clientConfig);
            this.addSSLConfiguration(clientBuilder);
            this.addProxyConfiguration(clientConfig);
            if (this.hostnameVerifier != null) {
                clientBuilder.hostnameVerifier(this.hostnameVerifier);
            }
            final String fullUserAgentName = (this.userAgent == null ? this.clientName : this.userAgent) + "/v" + DiscoveryBuildInfo.buildVersion();
            clientBuilder.register((Object)new ClientRequestFilter(){

                public void filter(ClientRequestContext requestContext) {
                    requestContext.getHeaders().put((Object)"User-Agent", Collections.singletonList(fullUserAgentName));
                }
            });
            clientConfig.property("jersey.config.client.followRedirects", (Object)this.allowRedirect);
            clientConfig.property("jersey.config.client.readTimeout", (Object)this.readTimeout);
            clientConfig.property("jersey.config.client.connectTimeout", (Object)this.connectionTimeout);
            clientBuilder.withConfig((Configuration)clientConfig);
            clientBuilder.register((Object)new GZipEncoder());
            String ip = this.myInstanceInfo == null ? null : this.myInstanceInfo.getIPAddr();
            EurekaClientIdentity identity = this.clientIdentity == null ? new EurekaClientIdentity(ip) : this.clientIdentity;
            clientBuilder.register((Object)new Jersey3EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
            JerseyClient jerseyClient = (JerseyClient)clientBuilder.build();
            MultivaluedHashMap additionalHeaders = new MultivaluedHashMap();
            if (this.allowRedirect) {
                additionalHeaders.add((Object)Jersey3ApplicationClientFactory.HTTP_X_DISCOVERY_ALLOW_REDIRECT, (Object)"true");
            }
            if (EurekaAccept.compact == this.eurekaAccept) {
                additionalHeaders.add((Object)"X-Eureka-Accept", (Object)this.eurekaAccept.name());
            }
            return new Jersey3ApplicationClientFactory((Client)jerseyClient, (MultivaluedMap<String, Object>)additionalHeaders);
        }

        private void addSSLConfiguration(ClientBuilder clientBuilder) {
            FileInputStream fin = null;
            try {
                if (this.systemSSL) {
                    clientBuilder.sslContext(SSLContext.getDefault());
                } else if (this.trustStoreFileName != null) {
                    KeyStore trustStore = KeyStore.getInstance(Jersey3ApplicationClientFactory.KEY_STORE_TYPE);
                    fin = new FileInputStream(this.trustStoreFileName);
                    trustStore.load(fin, this.trustStorePassword.toCharArray());
                    clientBuilder.trustStore(trustStore);
                } else if (this.sslContext != null) {
                    clientBuilder.sslContext(this.sslContext);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot setup SSL for Jersey3 client", ex);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private void addProxyConfiguration(ClientConfig clientConfig) {
            if (this.proxyHost != null) {
                String proxyAddress = this.proxyHost;
                if (this.proxyPort > 0) {
                    proxyAddress = proxyAddress + (58 + this.proxyPort);
                }
                clientConfig.property("jersey.config.client.proxy.uri", (Object)proxyAddress);
                if (this.proxyUserName != null) {
                    if (this.proxyPassword == null) {
                        throw new IllegalArgumentException("Proxy user name provided but not password");
                    }
                    clientConfig.property("jersey.config.client.proxy.username", (Object)this.proxyUserName);
                    clientConfig.property("jersey.config.client.proxy.password", (Object)this.proxyPassword);
                }
            }
        }

        private void addProviders(ClientConfig clientConfig) {
            DiscoveryJerseyProvider discoveryJerseyProvider = new DiscoveryJerseyProvider(this.encoderWrapper, this.decoderWrapper);
            clientConfig.register((Object)discoveryJerseyProvider);
            clientConfig.property("jersey.config.client.disableJsonProcessing", (Object)Boolean.TRUE);
            clientConfig.property("jersey.config.client.disableMoxyJson", (Object)Boolean.TRUE);
        }
    }
}

