/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.schedule;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.kernel.internal.instance.InstanceService;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobShutdownHookPlugin
implements SchedulerPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobShutdownHookPlugin.class);
    private String jobName;
    private boolean cleanShutdown = true;

    public void initialize(String name, Scheduler scheduler, ClassLoadHelper classLoadHelper) throws SchedulerException {
        this.jobName = scheduler.getSchedulerName();
        this.registerShutdownHook();
    }

    public void start() {
    }

    public void shutdown() {
        CoordinatorRegistryCenter regCenter = JobRegistry.getInstance().getRegCenter(this.jobName);
        if (null == regCenter) {
            return;
        }
        LeaderService leaderService = new LeaderService(regCenter, this.jobName);
        if (leaderService.isLeader()) {
            leaderService.removeLeader();
        }
        new InstanceService(regCenter, this.jobName).removeInstance();
    }

    private void registerShutdownHook() {
        log.info("Registering Quartz shutdown hook. {}", (Object)this.jobName);
        Thread t = new Thread("Quartz Shutdown-Hook " + this.jobName){

            @Override
            public void run() {
                log.info("Shutting down Quartz... {}", (Object)JobShutdownHookPlugin.this.jobName);
                JobScheduleController scheduleController = JobRegistry.getInstance().getJobScheduleController(JobShutdownHookPlugin.this.jobName);
                if (null != scheduleController) {
                    scheduleController.shutdown(JobShutdownHookPlugin.this.isCleanShutdown());
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public boolean isCleanShutdown() {
        return this.cleanShutdown;
    }

    @Generated
    public void setCleanShutdown(boolean cleanShutdown) {
        this.cleanShutdown = cleanShutdown;
    }
}

