/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.generator.BaseGeneratedKeyTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.keygen.pojo.GeneratedKeyInsertColumnToken;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.InsertColumnsSegment;

public final class GeneratedKeyInsertColumnTokenGenerator
extends BaseGeneratedKeyTokenGenerator {
    @Override
    protected boolean isGenerateSQLToken(InsertStatementContext statementContext) {
        Optional insertColumns = statementContext.getSqlStatement().getInsertColumns();
        return insertColumns.isPresent() && !((InsertColumnsSegment)insertColumns.get()).getColumns().isEmpty() && statementContext.getGeneratedKeyContext().isPresent() && !((GeneratedKeyContext)statementContext.getGeneratedKeyContext().get()).getGeneratedValues().isEmpty();
    }

    public GeneratedKeyInsertColumnToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Optional generatedKey = insertStatementContext.getGeneratedKeyContext();
        Preconditions.checkState((boolean)generatedKey.isPresent());
        Optional insertColumns = insertStatementContext.getSqlStatement().getInsertColumns();
        Preconditions.checkState((boolean)insertColumns.isPresent());
        return new GeneratedKeyInsertColumnToken(((InsertColumnsSegment)insertColumns.get()).getStopIndex(), ((GeneratedKeyContext)generatedKey.get()).getColumnName());
    }
}

