/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.PrepareStatement;

public final class PrepareStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public PrepareStatementContext(PrepareStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.extractTablesFromPreparedStatement(sqlStatement));
    }

    private Collection<SimpleTableSegment> extractTablesFromPreparedStatement(PrepareStatement sqlStatement) {
        TableExtractor tableExtractor = new TableExtractor();
        sqlStatement.getSelect().ifPresent(arg_0 -> ((TableExtractor)tableExtractor).extractTablesFromSelect(arg_0));
        sqlStatement.getInsert().ifPresent(arg_0 -> ((TableExtractor)tableExtractor).extractTablesFromInsert(arg_0));
        sqlStatement.getUpdate().ifPresent(arg_0 -> ((TableExtractor)tableExtractor).extractTablesFromUpdate(arg_0));
        sqlStatement.getDelete().ifPresent(arg_0 -> ((TableExtractor)tableExtractor).extractTablesFromDelete(arg_0));
        return new LinkedList<SimpleTableSegment>(tableExtractor.getRewriteTables());
    }

    public PrepareStatement getSqlStatement() {
        return (PrepareStatement)super.getSqlStatement();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

