/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.DataConsistencyCheckUtils;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineIndexMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.identifier.ShardingSphereIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardPipelineTableMetaDataLoader
implements PipelineTableMetaDataLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardPipelineTableMetaDataLoader.class);
    private final PipelineDataSource dataSource;
    private final Map<ShardingSphereIdentifier, PipelineTableMetaData> tableMetaDataMap = new ConcurrentHashMap<ShardingSphereIdentifier, PipelineTableMetaData>();

    @Override
    public PipelineTableMetaData getTableMetaData(String schemaName, String tableName) {
        PipelineTableMetaData result = this.tableMetaDataMap.get(new ShardingSphereIdentifier(tableName));
        if (null != result) {
            return result;
        }
        try {
            this.loadTableMetaData(schemaName, tableName);
        }
        catch (SQLException ex) {
            throw new PipelineInternalException(String.format("Load meta data for schema '%s' and table '%s' failed", schemaName, tableName), ex);
        }
        result = this.tableMetaDataMap.get(new ShardingSphereIdentifier(tableName));
        if (null == result) {
            log.warn("Can not load meta data for table '{}'", (Object)tableName);
        }
        return result;
    }

    private void loadTableMetaData(String schemaName, String tableName) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(this.dataSource.getDatabaseType()).getDialectDatabaseMetaData();
            this.tableMetaDataMap.putAll(this.loadTableMetaData(connection, dialectDatabaseMetaData.isSchemaAvailable() ? schemaName : null, tableName));
        }
    }

    private Map<ShardingSphereIdentifier, PipelineTableMetaData> loadTableMetaData(Connection connection, String schemaName, String tableNamePattern) throws SQLException {
        LinkedList<String> tableNames = new LinkedList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), schemaName, tableNamePattern, null);){
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("TABLE_NAME"));
            }
        }
        LinkedHashMap<ShardingSphereIdentifier, PipelineTableMetaData> result = new LinkedHashMap<ShardingSphereIdentifier, PipelineTableMetaData>(tableNames.size(), 1.0f);
        for (String each : tableNames) {
            Collection<ShardingSphereIdentifier> primaryKeys = this.loadPrimaryKeys(connection, schemaName, each);
            Map<ShardingSphereIdentifier, Collection<ShardingSphereIdentifier>> uniqueKeys = this.loadUniqueKeys(connection, schemaName, each);
            LinkedHashMap<ShardingSphereIdentifier, PipelineColumnMetaData> columnMetaDataMap = new LinkedHashMap<ShardingSphereIdentifier, PipelineColumnMetaData>();
            try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), schemaName, each, "%");){
                while (resultSet.next()) {
                    int ordinalPosition = resultSet.getInt("ORDINAL_POSITION");
                    ShardingSphereIdentifier columnName = new ShardingSphereIdentifier(resultSet.getString("COLUMN_NAME"));
                    if (columnMetaDataMap.containsKey(columnName)) continue;
                    int dataType = resultSet.getInt("DATA_TYPE");
                    String dataTypeName = resultSet.getString("TYPE_NAME");
                    boolean primaryKey = primaryKeys.contains(columnName);
                    boolean isNullable = "YES".equals(resultSet.getString("IS_NULLABLE"));
                    boolean isUniqueKey = uniqueKeys.values().stream().anyMatch(names -> names.contains(columnName));
                    columnMetaDataMap.put(columnName, new PipelineColumnMetaData(ordinalPosition, columnName.toString(), dataType, dataTypeName, isNullable, primaryKey, isUniqueKey));
                }
            }
            Collection uniqueIndexMetaData = uniqueKeys.entrySet().stream().map(entry -> new PipelineIndexMetaData((ShardingSphereIdentifier)entry.getKey(), ((Collection)entry.getValue()).stream().map(columnMetaDataMap::get).collect(Collectors.toList()), DataConsistencyCheckUtils.compareLists(primaryKeys, (Collection)entry.getValue()))).collect(Collectors.toList());
            result.put(new ShardingSphereIdentifier(each), new PipelineTableMetaData(each, columnMetaDataMap, uniqueIndexMetaData));
        }
        return result;
    }

    private Collection<ShardingSphereIdentifier> loadPrimaryKeys(Connection connection, String schemaName, String tableName) throws SQLException {
        TreeMap<Short, ShardingSphereIdentifier> result = new TreeMap<Short, ShardingSphereIdentifier>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), schemaName, tableName);){
            while (resultSet.next()) {
                result.put(resultSet.getShort("KEY_SEQ"), new ShardingSphereIdentifier(resultSet.getString("COLUMN_NAME")));
            }
        }
        return result.values();
    }

    private Map<ShardingSphereIdentifier, Collection<ShardingSphereIdentifier>> loadUniqueKeys(Connection connection, String schemaName, String tableName) throws SQLException {
        LinkedHashMap<String, SortedMap> orderedColumnsOfIndexes = new LinkedHashMap<String, SortedMap>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), schemaName, tableName, true, true);){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                if (null == indexName) continue;
                orderedColumnsOfIndexes.computeIfAbsent(indexName, unused -> new TreeMap()).put(resultSet.getShort("ORDINAL_POSITION"), new ShardingSphereIdentifier(resultSet.getString("COLUMN_NAME")));
            }
        }
        LinkedHashMap<ShardingSphereIdentifier, Collection<ShardingSphereIdentifier>> result = new LinkedHashMap<ShardingSphereIdentifier, Collection<ShardingSphereIdentifier>>();
        for (Map.Entry entry : orderedColumnsOfIndexes.entrySet()) {
            Collection columnNames = result.computeIfAbsent(new ShardingSphereIdentifier((String)entry.getKey()), unused -> new LinkedList());
            columnNames.addAll(((SortedMap)entry.getValue()).values());
        }
        return result;
    }

    @Generated
    public StandardPipelineTableMetaDataLoader(PipelineDataSource dataSource) {
        this.dataSource = dataSource;
    }
}

