/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.engine;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.job.engine.cleaner.PipelineJobRunnerCleaner;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;
import org.apache.shardingsphere.data.pipeline.core.listener.PipelineElasticJobListener;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.task.runner.PipelineTasksRunner;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDistributedBarrier;
import org.apache.shardingsphere.elasticjob.infra.listener.ElasticJobListener;
import org.apache.shardingsphere.elasticjob.infra.spi.ElasticJobServiceLoader;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.JobBootstrap;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobRunnerManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobRunnerManager.class);
    private static final long JOB_WAITING_TIMEOUT_MILLS = 2000L;
    private final PipelineJobRunnerCleaner cleaner;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final AtomicReference<JobBootstrap> jobBootstrap = new AtomicReference();
    private final Map<Integer, PipelineTasksRunner> tasksRunners = new ConcurrentHashMap<Integer, PipelineTasksRunner>();
    private final PipelineDataSourceManager dataSourceManager = new PipelineDataSourceManager();

    public PipelineJobRunnerManager() {
        this(null);
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public void setJobBootstrap(JobBootstrap jobBootstrap) {
        this.jobBootstrap.set(jobBootstrap);
    }

    public Optional<PipelineTasksRunner> getTasksRunner(int shardingItem) {
        return Optional.ofNullable(this.tasksRunners.get(shardingItem));
    }

    public Collection<Integer> getShardingItems() {
        return this.tasksRunners.keySet();
    }

    public boolean addTasksRunner(int shardingItem, PipelineTasksRunner tasksRunner) {
        if (null != this.tasksRunners.putIfAbsent(shardingItem, tasksRunner)) {
            log.warn("Tasks runner on sharding item {} exists, ignore.", (Object)shardingItem);
            return false;
        }
        String jobId = tasksRunner.getJobItemContext().getJobId();
        PipelineJobProgressPersistService.add(jobId, shardingItem);
        PipelineDistributedBarrier.getInstance(PipelineJobIdUtils.parseContextKey(jobId)).persistEphemeralChildrenNode(PipelineMetaDataNode.getJobBarrierEnablePath(jobId), shardingItem);
        return true;
    }

    public void stop() {
        Optional<String> jobId = this.tasksRunners.values().stream().findFirst().map(each -> each.getJobItemContext().getJobId());
        try {
            this.stopping.set(true);
            log.info("Stop tasks runner, jobId={}", jobId);
            this.tasksRunners.values().forEach(PipelineTasksRunner::stop);
            jobId.ifPresent(this::awaitJobStopped);
            if (null != this.jobBootstrap.get()) {
                this.jobBootstrap.get().shutdown();
            }
        }
        finally {
            jobId.ifPresent(PipelineJobProgressPersistService::remove);
            this.tasksRunners.values().stream().map(each -> each.getJobItemContext().getJobProcessContext()).forEach(QuietlyCloser::close);
            this.dataSourceManager.close();
            if (null != this.cleaner) {
                this.cleaner.clean();
            }
        }
    }

    private void awaitJobStopped(String jobId) {
        Optional jobListener = ElasticJobServiceLoader.getCachedTypedServiceInstance(ElasticJobListener.class, (String)PipelineElasticJobListener.class.getName());
        if (!jobListener.isPresent()) {
            return;
        }
        long sleepMillis = 50L;
        for (long spentMills = 0L; spentMills < 2000L && ((PipelineElasticJobListener)jobListener.get()).isJobRunning(jobId); spentMills += sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
                continue;
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Generated
    public PipelineJobRunnerManager(PipelineJobRunnerCleaner cleaner) {
        this.cleaner = cleaner;
    }

    @Generated
    public PipelineDataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }
}

