/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;

public final class DataRecord
extends Record {
    private final PipelineSQLOperationType type;
    private final String schemaName;
    private final String tableName;
    private final List<Column> columns;
    private final Collection<Object> uniqueKeyValue = new LinkedList<Object>();
    private final Collection<Object> oldUniqueKeyValues = new LinkedList<Object>();
    private String actualTableName;
    private Long csn;

    public DataRecord(PipelineSQLOperationType type, String tableName, IngestPosition position, int columnCount) {
        this(type, null, tableName, position, columnCount);
    }

    public DataRecord(PipelineSQLOperationType type, String schemaName, String tableName, IngestPosition position, int columnCount) {
        super(position);
        this.type = type;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columns = new ArrayList<Column>(columnCount);
    }

    public void addColumn(Column data) {
        this.columns.add(data);
        if (data.isUniqueKey()) {
            this.uniqueKeyValue.add(data.getValue());
            this.oldUniqueKeyValues.add(data.getOldValue());
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public Key getKey() {
        return new Key(this.tableName, this.uniqueKeyValue);
    }

    public Key getOldKey() {
        return new Key(this.tableName, this.oldUniqueKeyValues);
    }

    @Generated
    public PipelineSQLOperationType getType() {
        return this.type;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public Collection<Object> getUniqueKeyValue() {
        return this.uniqueKeyValue;
    }

    @Generated
    public Collection<Object> getOldUniqueKeyValues() {
        return this.oldUniqueKeyValues;
    }

    @Generated
    public String getActualTableName() {
        return this.actualTableName;
    }

    @Generated
    public Long getCsn() {
        return this.csn;
    }

    @Generated
    public void setActualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    @Generated
    public void setCsn(Long csn) {
        this.csn = csn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataRecord)) {
            return false;
        }
        DataRecord other = (DataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "DataRecord(type=" + (Object)((Object)this.getType()) + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", columns=" + this.getColumns() + ", uniqueKeyValue=" + this.getUniqueKeyValue() + ", oldUniqueKeyValues=" + this.getOldUniqueKeyValues() + ", actualTableName=" + this.getActualTableName() + ", csn=" + this.getCsn() + ")";
    }

    public static class Key {
        private final String tableName;
        private final Collection<Object> uniqueKeyValues;

        @Generated
        public Key(String tableName, Collection<Object> uniqueKeyValues) {
            this.tableName = tableName;
            this.uniqueKeyValues = uniqueKeyValues;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableName = this.tableName;
            String other$tableName = other.tableName;
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            Collection<Object> this$uniqueKeyValues = this.uniqueKeyValues;
            Collection<Object> other$uniqueKeyValues = other.uniqueKeyValues;
            return !(this$uniqueKeyValues == null ? other$uniqueKeyValues != null : !((Object)this$uniqueKeyValues).equals(other$uniqueKeyValues));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableName = this.tableName;
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            Collection<Object> $uniqueKeyValues = this.uniqueKeyValues;
            result = result * 59 + ($uniqueKeyValues == null ? 43 : ((Object)$uniqueKeyValues).hashCode());
            return result;
        }
    }
}

