/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.attribute;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.rule.attribute.table.TableMapperRuleAttribute;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class ShardingTableNamesRuleAttribute
implements TableMapperRuleAttribute {
    private final Collection<String> logicalTableNames;
    private final Collection<String> actualTableNames;

    public ShardingTableNamesRuleAttribute(Collection<ShardingTable> shardingTables) {
        this.logicalTableNames = this.createLogicalTableNames(shardingTables);
        this.actualTableNames = this.createActualTableNames(shardingTables);
    }

    private Collection<String> createLogicalTableNames(Collection<ShardingTable> shardingTables) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        shardingTables.forEach(arg_0 -> ShardingTableNamesRuleAttribute.lambda$createLogicalTableNames$0((Collection)result, arg_0));
        return result;
    }

    private Collection<String> createActualTableNames(Collection<ShardingTable> shardingTables) {
        CaseInsensitiveSet result = new CaseInsensitiveSet();
        shardingTables.stream().flatMap(each -> each.getActualDataNodes().stream()).map(DataNode::getTableName).forEach(((Collection)result)::add);
        return result;
    }

    public Collection<String> getLogicTableNames() {
        return this.logicalTableNames;
    }

    public Collection<String> getActualTableNames() {
        return this.actualTableNames;
    }

    public Collection<String> getDistributedTableNames() {
        return this.logicalTableNames;
    }

    public Collection<String> getEnhancedTableNames() {
        return this.logicalTableNames;
    }

    private static /* synthetic */ void lambda$createLogicalTableNames$0(Collection result, ShardingTable each) {
        result.add(each.getLogicTable());
    }
}

