/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportStorageNodesStatement;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedStorageNode;
import org.apache.shardingsphere.proxy.backend.distsql.export.ExportedStorageNodes;
import org.apache.shardingsphere.proxy.backend.util.ExportUtils;

public final class ExportStorageNodesExecutor
implements DistSQLQueryExecutor<ExportStorageNodesStatement> {
    public Collection<String> getColumnNames(ExportStorageNodesStatement sqlStatement) {
        return Arrays.asList("id", "create_time", "storage_nodes");
    }

    public Collection<LocalDataQueryResultRow> getRows(ExportStorageNodesStatement sqlStatement, ContextManager contextManager) {
        this.checkSQLStatement(contextManager.getMetaDataContexts().getMetaData(), sqlStatement);
        String exportedData = this.generateExportData(contextManager.getMetaDataContexts().getMetaData(), sqlStatement);
        if (sqlStatement.getFilePath().isPresent()) {
            String filePath = (String)sqlStatement.getFilePath().get();
            ExportUtils.exportToFile(filePath, exportedData);
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId(), LocalDateTime.now(), String.format("Successfully exported to\uff1a'%s'", filePath)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId(), LocalDateTime.now(), exportedData}));
    }

    private void checkSQLStatement(ShardingSphereMetaData metaData, ExportStorageNodesStatement sqlStatement) {
        ShardingSpherePreconditions.checkState((null == sqlStatement.getDatabaseName() || null != metaData.getDatabase(sqlStatement.getDatabaseName()) ? 1 : 0) != 0, () -> new IllegalArgumentException(String.format("database %s is not existed", sqlStatement.getDatabaseName())));
    }

    private String generateExportData(ShardingSphereMetaData metaData, ExportStorageNodesStatement sqlStatement) {
        ExportedStorageNodes storageNodes = new ExportedStorageNodes();
        storageNodes.setStorageNodes(null == sqlStatement.getDatabaseName() ? this.getAllStorageNodes(metaData) : this.generateDatabaseExportStorageNodesData(metaData.getDatabase(sqlStatement.getDatabaseName())));
        return JsonUtils.toJsonString((Object)storageNodes);
    }

    private Map<String, Collection<ExportedStorageNode>> getAllStorageNodes(ShardingSphereMetaData metaData) {
        LinkedHashMap<String, Collection<ExportedStorageNode>> storageNodes = new LinkedHashMap<String, Collection<ExportedStorageNode>>();
        for (ShardingSphereDatabase each : metaData.getAllDatabases()) {
            if (each.getResourceMetaData().getAllInstanceDataSourceNames().isEmpty()) continue;
            storageNodes.putAll(this.generateDatabaseExportStorageNodesData(each));
        }
        return storageNodes;
    }

    private Map<String, Collection<ExportedStorageNode>> generateDatabaseExportStorageNodesData(ShardingSphereDatabase database) {
        LinkedHashMap<String, ExportedStorageNode> storageNodes = new LinkedHashMap<String, ExportedStorageNode>(database.getResourceMetaData().getStorageUnits().size(), 1.0f);
        for (Map.Entry entry : database.getResourceMetaData().getStorageUnits().entrySet()) {
            ConnectionProperties connectionProps = ((StorageUnit)database.getResourceMetaData().getStorageUnits().get(entry.getKey())).getConnectionProperties();
            String databaseInstanceIp = this.getDatabaseInstanceIp(connectionProps);
            if (storageNodes.containsKey(databaseInstanceIp)) continue;
            Map standardProps = DataSourcePoolPropertiesCreator.create((DataSource)((StorageUnit)entry.getValue()).getDataSource()).getConnectionPropertySynonyms().getStandardProperties();
            ExportedStorageNode exportedStorageNode = new ExportedStorageNode(connectionProps.getHostname(), String.valueOf(connectionProps.getPort()), String.valueOf(standardProps.get("username")), String.valueOf(standardProps.get("password")), connectionProps.getCatalog());
            storageNodes.put(databaseInstanceIp, exportedStorageNode);
        }
        return Collections.singletonMap(database.getName(), storageNodes.values());
    }

    private String getDatabaseInstanceIp(ConnectionProperties connectionProps) {
        return String.format("%s:%s", connectionProps.getHostname(), connectionProps.getPort());
    }

    public Class<ExportStorageNodesStatement> getType() {
        return ExportStorageNodesStatement.class;
    }
}

