/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.datasource;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.database.core.GlobalDataSourceRegistry;
import org.apache.shardingsphere.infra.exception.kernel.connection.OverallConnectionNotEnoughException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.BackendDataSource;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.ShardingSphereDistributedTransactionManager;

public final class JDBCBackendDataSource
implements BackendDataSource {
    public List<Connection> getConnections(String databaseName, String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        return this.getConnections(databaseName, dataSourceName, connectionSize, connectionMode, ((TransactionRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class)).getDefaultType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String databaseName, String dataSourceName, int connectionSize, ConnectionMode connectionMode, TransactionType transactionType) throws SQLException {
        DataSource dataSource = ((StorageUnit)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData().getStorageUnits().get(dataSourceName)).getDataSource();
        if (dataSourceName.contains(".")) {
            String dataSourceStr = dataSourceName.split("\\.")[0];
            if (GlobalDataSourceRegistry.getInstance().getCachedDataSources().containsKey(dataSourceStr)) {
                dataSource = (DataSource)GlobalDataSourceRegistry.getInstance().getCachedDataSources().get(dataSourceStr);
            }
        }
        Preconditions.checkNotNull((Object)dataSource, (String)"Can not get connection from datasource %s.", (Object)dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(this.createConnection(databaseName, dataSourceName, dataSource, transactionType));
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, transactionType);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, transactionType);
        }
    }

    private List<Connection> createConnections(String databaseName, String dataSourceName, DataSource dataSource, int connectionSize, TransactionType transactionType) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                result.add(this.createConnection(databaseName, dataSourceName, dataSource, transactionType));
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new OverallConnectionNotEnoughException(connectionSize, result.size(), (Exception)ex);
            }
        }
        return result;
    }

    private Connection createConnection(String databaseName, String dataSourceName, DataSource dataSource, TransactionType transactionType) throws SQLException {
        Connection result;
        TransactionRule transactionRule = (TransactionRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        ShardingSphereDistributedTransactionManager distributedTransactionManager = transactionRule.getResource().getTransactionManager(transactionType);
        Connection connection = result = this.isInTransaction(distributedTransactionManager) ? distributedTransactionManager.getConnection(databaseName, dataSourceName) : dataSource.getConnection();
        if (dataSourceName.contains(".")) {
            String catalog = dataSourceName.split("\\.")[1];
            result.setCatalog(catalog);
        }
        return result;
    }

    private boolean isInTransaction(ShardingSphereDistributedTransactionManager distributedTransactionManager) {
        return null != distributedTransactionManager && distributedTransactionManager.isInTransaction();
    }
}

