/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.statement.core.extractor;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BetweenExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.RowExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.DatetimeProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.IntervalExpressionProjection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.join.OuterJoinExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.CollectionTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class ColumnExtractor {
    public static Collection<ColumnSegment> extract(ExpressionSegment expression) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        if (expression instanceof BinaryOperationExpression) {
            if (((BinaryOperationExpression)expression).getLeft() instanceof ColumnSegment) {
                result.add((ColumnSegment)((BinaryOperationExpression)expression).getLeft());
            }
            if (((BinaryOperationExpression)expression).getRight() instanceof ColumnSegment) {
                result.add((ColumnSegment)((BinaryOperationExpression)expression).getRight());
            }
            if (((BinaryOperationExpression)expression).getLeft() instanceof OuterJoinExpression) {
                result.add(((OuterJoinExpression)((BinaryOperationExpression)expression).getLeft()).getColumnName());
            }
            if (((BinaryOperationExpression)expression).getRight() instanceof OuterJoinExpression) {
                result.add(((OuterJoinExpression)((BinaryOperationExpression)expression).getRight()).getColumnName());
            }
        }
        if (expression instanceof InExpression && ((InExpression)expression).getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)((InExpression)expression).getLeft());
        }
        if (expression instanceof InExpression && ((InExpression)expression).getLeft() instanceof RowExpression) {
            ColumnExtractor.extractColumnInRowExpression((InExpression)expression, result);
        }
        if (expression instanceof BetweenExpression && ((BetweenExpression)expression).getLeft() instanceof ColumnSegment) {
            result.add((ColumnSegment)((BetweenExpression)expression).getLeft());
        }
        return result;
    }

    private static void extractColumnInRowExpression(InExpression expression, Collection<ColumnSegment> result) {
        for (ExpressionSegment each : ((RowExpression)expression.getLeft()).getItems()) {
            if (!(each instanceof ColumnSegment)) continue;
            result.add((ColumnSegment)each);
        }
    }

    public static void extractColumnSegments(Collection<ColumnSegment> columnSegments, Collection<WhereSegment> whereSegments) {
        for (WhereSegment each : whereSegments) {
            for (AndPredicate andPredicate : ExpressionExtractor.extractAndPredicates(each.getExpr())) {
                ColumnExtractor.extractColumnSegments(columnSegments, andPredicate);
            }
        }
    }

    private static void extractColumnSegments(Collection<ColumnSegment> columnSegments, AndPredicate andPredicate) {
        for (ExpressionSegment each : andPredicate.getPredicates()) {
            columnSegments.addAll(ColumnExtractor.extract(each));
        }
    }

    public static void extractFromSelectStatement(Collection<ColumnSegment> columnSegments, SelectStatement statement, boolean containsSubQuery) {
        ColumnExtractor.extractFromProjections(columnSegments, statement.getProjections().getProjections(), containsSubQuery);
        ColumnExtractor.extractFromSelectStatementWithoutProjection(columnSegments, statement, containsSubQuery);
    }

    public static void extractFromSelectStatementWithoutProjection(Collection<ColumnSegment> columnSegments, SelectStatement statement, boolean containsSubQuery) {
        statement.getFrom().ifPresent(optional -> ColumnExtractor.extractFromTable(columnSegments, optional, containsSubQuery));
        statement.getWhere().ifPresent(optional -> ColumnExtractor.extractFromWhere(columnSegments, optional, containsSubQuery));
        statement.getGroupBy().ifPresent(optional -> ColumnExtractor.extractFromGroupBy(columnSegments, optional, containsSubQuery));
        statement.getHaving().ifPresent(optional -> ColumnExtractor.extractFromHaving(columnSegments, optional, containsSubQuery));
        statement.getOrderBy().ifPresent(optional -> ColumnExtractor.extractFromOrderBy(columnSegments, optional, containsSubQuery));
        statement.getCombine().ifPresent(optional -> ColumnExtractor.extractFromSelectStatement(columnSegments, optional.getLeft().getSelect(), containsSubQuery));
        statement.getCombine().ifPresent(optional -> ColumnExtractor.extractFromSelectStatement(columnSegments, optional.getRight().getSelect(), containsSubQuery));
    }

    public static void extractFromProjections(Collection<ColumnSegment> columnSegments, Collection<ProjectionSegment> projections, boolean containsSubQuery) {
        for (ProjectionSegment each : projections) {
            if (each instanceof ColumnProjectionSegment) {
                columnSegments.add(((ColumnProjectionSegment)each).getColumn());
            }
            if (each instanceof AggregationProjectionSegment) {
                for (ExpressionSegment parameter : ((AggregationProjectionSegment)each).getParameters()) {
                    columnSegments.addAll(ExpressionExtractor.extractColumns(parameter, containsSubQuery));
                }
            }
            if (each instanceof DatetimeProjectionSegment) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((DatetimeProjectionSegment)each).getLeft(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((DatetimeProjectionSegment)each).getRight(), containsSubQuery));
            }
            if (each instanceof ExpressionProjectionSegment) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionProjectionSegment)each).getExpr(), containsSubQuery));
            }
            if (each instanceof IntervalExpressionProjection) {
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getLeft(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getRight(), containsSubQuery));
                columnSegments.addAll(ExpressionExtractor.extractColumns(((IntervalExpressionProjection)each).getMinus(), containsSubQuery));
            }
            if (!(each instanceof SubqueryProjectionSegment) || !containsSubQuery) continue;
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((SubqueryProjectionSegment)each).getSubquery().getSelect(), true);
        }
    }

    private static void extractFromTable(Collection<ColumnSegment> columnSegments, TableSegment tableSegment, boolean containsSubQuery) {
        if (tableSegment instanceof CollectionTableSegment) {
            columnSegments.addAll(ExpressionExtractor.extractColumns(((CollectionTableSegment)tableSegment).getExpressionSegment(), containsSubQuery));
        }
        if (tableSegment instanceof JoinTableSegment) {
            ColumnExtractor.extractFromTable(columnSegments, ((JoinTableSegment)tableSegment).getLeft(), containsSubQuery);
            ColumnExtractor.extractFromTable(columnSegments, ((JoinTableSegment)tableSegment).getRight(), containsSubQuery);
            columnSegments.addAll(ExpressionExtractor.extractColumns(((JoinTableSegment)tableSegment).getCondition(), containsSubQuery));
            columnSegments.addAll(((JoinTableSegment)tableSegment).getUsing());
            columnSegments.addAll(((JoinTableSegment)tableSegment).getDerivedUsing());
        }
        if (tableSegment instanceof SubqueryTableSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((SubqueryTableSegment)tableSegment).getSubquery().getSelect(), true);
        }
        if (tableSegment instanceof CommonTableExpressionSegment && containsSubQuery) {
            ColumnExtractor.extractFromSelectStatement(columnSegments, ((CommonTableExpressionSegment)tableSegment).getSubquery().getSelect(), true);
        }
    }

    public static void extractFromWhere(Collection<ColumnSegment> columnSegments, WhereSegment whereSegment, boolean containsSubQuery) {
        columnSegments.addAll(ExpressionExtractor.extractColumns(whereSegment.getExpr(), containsSubQuery));
    }

    private static void extractFromGroupBy(Collection<ColumnSegment> columnSegments, GroupBySegment groupBySegment, boolean containsSubQuery) {
        for (OrderByItemSegment each : groupBySegment.getGroupByItems()) {
            if (each instanceof ColumnOrderByItemSegment) {
                columnSegments.add(((ColumnOrderByItemSegment)each).getColumn());
            }
            if (!(each instanceof ExpressionOrderByItemSegment)) continue;
            columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionOrderByItemSegment)each).getExpr(), containsSubQuery));
        }
    }

    private static void extractFromHaving(Collection<ColumnSegment> columnSegments, HavingSegment havingSegment, boolean containsSubQuery) {
        columnSegments.addAll(ExpressionExtractor.extractColumns(havingSegment.getExpr(), containsSubQuery));
    }

    private static void extractFromOrderBy(Collection<ColumnSegment> columnSegments, OrderBySegment orderBySegment, boolean containsSubQuery) {
        for (OrderByItemSegment each : orderBySegment.getOrderByItems()) {
            if (each instanceof ColumnOrderByItemSegment) {
                columnSegments.add(((ColumnOrderByItemSegment)each).getColumn());
            }
            if (!(each instanceof ExpressionOrderByItemSegment)) continue;
            columnSegments.addAll(ExpressionExtractor.extractColumns(((ExpressionOrderByItemSegment)each).getExpr(), containsSubQuery));
        }
    }

    @Generated
    private ColumnExtractor() {
    }
}

