/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.rdl.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.validate.DistSQLDataSourcePoolPropertiesValidator;
import org.apache.shardingsphere.distsql.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.segment.converter.DataSourceSegmentsConverter;
import org.apache.shardingsphere.distsql.statement.rdl.resource.unit.type.RegisterStorageUnitStatement;
import org.apache.shardingsphere.infra.database.core.checker.PrivilegeCheckType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.ShardingSphereExternalException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.DuplicateStorageUnitException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.StorageUnitsOperateException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datasource.DataSourceMapperRuleAttribute;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterStorageUnitExecutor
implements DistSQLUpdateExecutor<RegisterStorageUnitStatement>,
DistSQLExecutorDatabaseAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterStorageUnitExecutor.class);
    private final DistSQLDataSourcePoolPropertiesValidator validateHandler = new DistSQLDataSourcePoolPropertiesValidator();
    private ShardingSphereDatabase database;

    @Override
    public void executeUpdate(RegisterStorageUnitStatement sqlStatement, ContextManager contextManager) {
        this.checkDataSource(sqlStatement, contextManager);
        Map propsMap = DataSourceSegmentsConverter.convert((DatabaseType)this.database.getProtocolType(), (Collection)sqlStatement.getStorageUnits());
        if (sqlStatement.isIfNotExists()) {
            Collection<String> currentStorageUnits = this.getCurrentStorageUnitNames(contextManager);
            Collection<String> logicalDataSourceNames = this.getLogicalDataSourceNames();
            propsMap.keySet().removeIf(currentStorageUnits::contains);
            propsMap.keySet().removeIf(logicalDataSourceNames::contains);
        }
        if (propsMap.isEmpty()) {
            return;
        }
        this.validateHandler.validate(propsMap, this.getExpectedPrivileges(sqlStatement));
        try {
            contextManager.getPersistServiceFacade().getMetaDataManagerPersistService().registerStorageUnits(this.database.getName(), propsMap);
        }
        catch (SQLException | ShardingSphereExternalException ex) {
            throw new StorageUnitsOperateException("register", propsMap.keySet(), (Exception)ex);
        }
    }

    private void checkDataSource(RegisterStorageUnitStatement sqlStatement, ContextManager contextManager) {
        if (!sqlStatement.isIfNotExists()) {
            ArrayList<String> dataSourceNames = new ArrayList<String>(sqlStatement.getStorageUnits().size());
            this.checkDuplicatedDataSourceNames(contextManager, dataSourceNames, sqlStatement);
            this.checkDuplicatedLogicalDataSourceNames(dataSourceNames);
        }
    }

    private void checkDuplicatedDataSourceNames(ContextManager contextManager, Collection<String> dataSourceNames, RegisterStorageUnitStatement sqlStatement) {
        HashSet<String> duplicatedDataSourceNames = new HashSet<String>(sqlStatement.getStorageUnits().size(), 1.0f);
        for (DataSourceSegment each : sqlStatement.getStorageUnits()) {
            if (dataSourceNames.contains(each.getName()) || this.getCurrentStorageUnitNames(contextManager).contains(each.getName())) {
                duplicatedDataSourceNames.add(each.getName());
            }
            dataSourceNames.add(each.getName());
        }
        ShardingSpherePreconditions.checkMustEmpty(duplicatedDataSourceNames, () -> new DuplicateStorageUnitException(this.database.getName(), duplicatedDataSourceNames));
    }

    private void checkDuplicatedLogicalDataSourceNames(Collection<String> requiredDataSourceNames) {
        Collection<String> logicalDataSourceNames = this.getLogicalDataSourceNames();
        if (logicalDataSourceNames.isEmpty()) {
            return;
        }
        Collection duplicatedDataSourceNames = requiredDataSourceNames.stream().filter(logicalDataSourceNames::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedDataSourceNames, () -> new DuplicateStorageUnitException(this.database.getName(), duplicatedDataSourceNames));
    }

    private Collection<String> getCurrentStorageUnitNames(ContextManager contextManager) {
        return contextManager.getStorageUnits(this.database.getName()).keySet();
    }

    private Collection<String> getLogicalDataSourceNames() {
        return this.database.getRuleMetaData().getAttributes(DataSourceMapperRuleAttribute.class).stream().flatMap(each -> each.getDataSourceMapper().keySet().stream()).collect(Collectors.toList());
    }

    private Collection<PrivilegeCheckType> getExpectedPrivileges(RegisterStorageUnitStatement sqlStatement) {
        Collection result = sqlStatement.getExpectedPrivileges().stream().map(each -> PrivilegeCheckType.valueOf((String)each.toUpperCase())).collect(Collectors.toSet());
        if (result.isEmpty()) {
            result.add(PrivilegeCheckType.SELECT);
        }
        return result;
    }

    @Override
    public Class<RegisterStorageUnitStatement> getType() {
        return RegisterStorageUnitStatement.class;
    }

    @Override
    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }
}

