/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.engine.update;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorAwareSetter;
import org.apache.shardingsphere.distsql.handler.engine.update.AdvancedDistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.DistSQLUpdateExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.database.DatabaseRuleDefinitionExecuteEngine;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.engine.global.GlobalRuleDefinitionExecuteEngine;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.global.GlobalRuleDefinitionExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorRequiredChecker;
import org.apache.shardingsphere.distsql.handler.util.DatabaseNameUtils;
import org.apache.shardingsphere.distsql.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.statement.rdl.rule.RuleDefinitionStatement;
import org.apache.shardingsphere.distsql.statement.rdl.rule.database.DatabaseRuleDefinitionStatement;
import org.apache.shardingsphere.distsql.statement.rdl.rule.global.GlobalRuleDefinitionStatement;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class DistSQLUpdateExecuteEngine {
    private final DistSQLStatement sqlStatement;
    private final ContextManager contextManager;
    private final String databaseName;

    public DistSQLUpdateExecuteEngine(DistSQLStatement sqlStatement, String currentDatabaseName, ContextManager contextManager) {
        this.sqlStatement = sqlStatement;
        this.contextManager = contextManager;
        this.databaseName = DatabaseNameUtils.getDatabaseName((SQLStatement)sqlStatement, currentDatabaseName);
    }

    public void executeUpdate() throws SQLException {
        if (this.sqlStatement instanceof RuleDefinitionStatement) {
            this.executeRuleDefinitionUpdate();
        } else {
            this.executeNormalUpdate();
        }
    }

    private void executeRuleDefinitionUpdate() throws SQLException {
        Optional databaseExecutor = TypedSPILoader.findService(DatabaseRuleDefinitionExecutor.class, this.sqlStatement.getClass());
        if (databaseExecutor.isPresent()) {
            new DatabaseRuleDefinitionExecuteEngine((DatabaseRuleDefinitionStatement)this.sqlStatement, this.contextManager, this.databaseName, (DatabaseRuleDefinitionExecutor)databaseExecutor.get()).executeUpdate();
        } else {
            new GlobalRuleDefinitionExecuteEngine((GlobalRuleDefinitionStatement)this.sqlStatement, this.contextManager, (GlobalRuleDefinitionExecutor)TypedSPILoader.getService(GlobalRuleDefinitionExecutor.class, this.sqlStatement.getClass())).executeUpdate();
        }
    }

    private void executeNormalUpdate() throws SQLException {
        Optional advancedExecutor = TypedSPILoader.findService(AdvancedDistSQLUpdateExecutor.class, this.sqlStatement.getClass());
        DistSQLUpdateExecutor executor = advancedExecutor.isPresent() ? (DistSQLUpdateExecutor)advancedExecutor.get() : (DistSQLUpdateExecutor)TypedSPILoader.getService(DistSQLUpdateExecutor.class, this.sqlStatement.getClass());
        ShardingSphereDatabase database = null == this.databaseName ? null : this.contextManager.getDatabase(this.databaseName);
        new DistSQLExecutorAwareSetter(executor).set(this.contextManager, database, null, this.sqlStatement);
        new DistSQLExecutorRequiredChecker(executor).check((SQLStatement)this.sqlStatement, this.contextManager, database);
        executor.executeUpdate(this.sqlStatement, this.contextManager);
    }
}

