/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor.callback.execute;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.callback.execute.StatementExecuteUpdateCallback;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;

public final class ExecuteUpdateCallbackFactory {
    private final String jdbcDriverType;

    public JDBCExecutorCallback<Integer> newInstance(ShardingSphereDatabase database, SQLStatement sqlStatement, final StatementExecuteUpdateCallback updateCallback) {
        return new JDBCExecutorCallback<Integer>(database.getProtocolType(), database.getResourceMetaData(), sqlStatement, SQLExecutorExceptionHandler.isExceptionThrown()){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode, DatabaseType storageType) throws SQLException {
                return "JDBC.STATEMENT".equals(ExecuteUpdateCallbackFactory.this.jdbcDriverType) ? updateCallback.executeUpdate(sql, statement) : ((PreparedStatement)statement).executeUpdate();
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
                return Optional.empty();
            }
        };
    }

    @Generated
    public ExecuteUpdateCallbackFactory(String jdbcDriverType) {
        this.jdbcDriverType = jdbcDriverType;
    }
}

