/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.checker.sql.table;

import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.DropTableStatementContext;
import org.apache.shardingsphere.infra.checker.SupportedSQLChecker;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.UnsupportedDropCascadeTableException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropTableStatement;

public final class SingleDropTableSupportedChecker
implements SupportedSQLChecker<DropTableStatementContext, SingleRule> {
    public boolean isCheck(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext.getSqlStatement() instanceof DropTableStatement;
    }

    public void check(SingleRule rule, ShardingSphereDatabase database, ShardingSphereSchema currentSchema, DropTableStatementContext sqlStatementContext) {
        ShardingSpherePreconditions.checkState((!sqlStatementContext.getSqlStatement().isContainsCascade() ? 1 : 0) != 0, UnsupportedDropCascadeTableException::new);
    }
}

