/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.converter;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.AlgorithmDistSQLConverter;
import org.apache.shardingsphere.distsql.handler.engine.query.ral.convert.RuleConfigurationToDistSQLConverter;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowConvertDistSQLConstants;

public final class ShadowRuleConfigurationToDistSQLConverter
implements RuleConfigurationToDistSQLConverter<ShadowRuleConfiguration> {
    public String convert(ShadowRuleConfiguration ruleConfig) {
        return ruleConfig.getDataSources().isEmpty() ? "" : "CREATE SHADOW RULE" + this.convertShadowDataSources(ruleConfig) + ";";
    }

    private String convertShadowDataSources(ShadowRuleConfiguration ruleConfig) {
        return ruleConfig.getDataSources().stream().map(each -> this.convertShadowDataSource((ShadowDataSourceConfiguration)each, ruleConfig)).collect(Collectors.joining(","));
    }

    private String convertShadowDataSource(ShadowDataSourceConfiguration dataSourceConfig, ShadowRuleConfiguration ruleConfig) {
        String shadowTables = this.convertShadowTables(dataSourceConfig.getName(), ruleConfig.getTables(), ruleConfig.getShadowAlgorithms());
        return String.format(ShadowConvertDistSQLConstants.SHADOW_DATA_SOURCE, dataSourceConfig.getName(), dataSourceConfig.getProductionDataSourceName(), dataSourceConfig.getShadowDataSourceName(), shadowTables);
    }

    private String convertShadowTables(String shadowRuleName, Map<String, ShadowTableConfiguration> tableConfigs, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        return tableConfigs.entrySet().stream().filter(entry -> ((ShadowTableConfiguration)entry.getValue()).getDataSourceNames().contains(shadowRuleName)).map(entry -> this.convertShadowTable((String)entry.getKey(), (ShadowTableConfiguration)entry.getValue(), algorithmConfigs)).collect(Collectors.joining("," + System.lineSeparator()));
    }

    private String convertShadowTable(String shadowTableName, ShadowTableConfiguration shadowTableConfig, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        String shadowTableTypes = this.convertShadowTableTypes(shadowTableConfig.getShadowAlgorithmNames(), algorithmConfigs);
        return String.format("%s(%s)", shadowTableName, shadowTableTypes);
    }

    private String convertShadowTableTypes(Collection<String> shadowAlgorithmNames, Map<String, AlgorithmConfiguration> algorithmConfigs) {
        return shadowAlgorithmNames.stream().map(each -> AlgorithmDistSQLConverter.getAlgorithmType((AlgorithmConfiguration)((AlgorithmConfiguration)algorithmConfigs.get(each)))).collect(Collectors.joining(", "));
    }

    public Class<ShadowRuleConfiguration> getType() {
        return ShadowRuleConfiguration.class;
    }
}

