/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.statement.ShowUnusedShardingAlgorithmsStatement;
import org.apache.shardingsphere.sharding.rule.ShardingRule;

public final class ShowUnusedShardingAlgorithmsExecutor
implements DistSQLQueryExecutor<ShowUnusedShardingAlgorithmsStatement>,
DistSQLExecutorRuleAware<ShardingRule> {
    private ShardingRule rule;

    public Collection<String> getColumnNames(ShowUnusedShardingAlgorithmsStatement sqlStatement) {
        return Arrays.asList("name", "type", "props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowUnusedShardingAlgorithmsStatement sqlStatement, ContextManager contextManager) {
        ShardingRuleConfiguration shardingRuleConfig = this.rule.getConfiguration();
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        Collection<String> inUsedAlgorithms = this.getUsedShardingAlgorithms(shardingRuleConfig);
        for (Map.Entry entry : shardingRuleConfig.getShardingAlgorithms().entrySet()) {
            if (inUsedAlgorithms.contains(entry.getKey())) continue;
            result.add(new LocalDataQueryResultRow(new Object[]{entry.getKey(), ((AlgorithmConfiguration)entry.getValue()).getType(), ((AlgorithmConfiguration)entry.getValue()).getProps()}));
        }
        return result;
    }

    private Collection<String> getUsedShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        ShardingStrategyConfiguration databaseShardingStrategy;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().forEach(each -> {
            if (null != each.getDatabaseShardingStrategy()) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (null != each.getTableShardingStrategy()) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        shardingRuleConfig.getAutoTables().stream().filter(each -> null != each.getShardingStrategy()).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        ShardingStrategyConfiguration tableShardingStrategy = shardingRuleConfig.getDefaultTableShardingStrategy();
        if (null != tableShardingStrategy && !Strings.isNullOrEmpty((String)tableShardingStrategy.getShardingAlgorithmName())) {
            result.add(tableShardingStrategy.getShardingAlgorithmName());
        }
        if (null != (databaseShardingStrategy = shardingRuleConfig.getDefaultDatabaseShardingStrategy()) && !Strings.isNullOrEmpty((String)databaseShardingStrategy.getShardingAlgorithmName())) {
            result.add(databaseShardingStrategy.getShardingAlgorithmName());
        }
        return result;
    }

    public Class<ShardingRule> getRuleClass() {
        return ShardingRule.class;
    }

    public Class<ShowUnusedShardingAlgorithmsStatement> getType() {
        return ShowUnusedShardingAlgorithmsStatement.class;
    }

    @Generated
    public void setRule(ShardingRule rule) {
        this.rule = rule;
    }
}

