/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.publish;

import com.atomikos.icatch.event.Event;
import com.atomikos.icatch.event.EventListener;
import com.atomikos.icatch.event.transaction.ParticipantHeuristicEvent;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;

public enum EventPublisher {
    INSTANCE;

    private static Logger LOGGER;
    private Set<EventListener> listeners = new HashSet<EventListener>();
    private boolean alreadyWarned = false;

    public void publish(Event event) {
        if (event != null) {
            this.notifyAllListeners(event);
        }
    }

    private void notifyAllListeners(Event event) {
        this.warnIfNoListeners(event);
        for (EventListener listener : this.listeners) {
            try {
                listener.eventOccurred(event);
            }
            catch (Exception e) {
                LOGGER.logError("Error notifying listener " + listener, e);
            }
        }
    }

    private void warnIfNoListeners(Event event) {
        if (this.listeners.isEmpty()) {
            if (!this.alreadyWarned) {
                LOGGER.logWarning("No event listeners are configured - you may want to consider https://www.atomikos.com/Main/ExtremeTransactions for detailed monitoring functionality...");
            }
            if (this.logEvent(event)) {
                LOGGER.logWarning(event.toString());
            }
            this.alreadyWarned = true;
        }
    }

    private boolean logEvent(Event event) {
        return !this.alreadyWarned || event instanceof ParticipantHeuristicEvent || event instanceof TransactionHeuristicEvent;
    }

    public void registerEventListener(EventListener listener) {
        LOGGER.logInfo("Registering EventListener: " + listener);
        this.listeners.add(listener);
    }

    static {
        LOGGER = LoggerFactory.createLogger(EventPublisher.class);
    }
}

