/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.retry;

import java.util.function.Predicate;
import lombok.Generated;

public final class RetryExecutor {
    private final long timeoutMillis;
    private final long intervalMillis;
    private long elapsedMillis;

    public <T> boolean execute(Predicate<T> predicate, T arg) {
        do {
            if (!predicate.test(arg)) continue;
            return true;
        } while (!this.isTimeout());
        return false;
    }

    private boolean isTimeout() {
        Thread.sleep(this.intervalMillis);
        if (this.timeoutMillis < 0L) {
            return false;
        }
        this.elapsedMillis += this.intervalMillis;
        return this.elapsedMillis > this.timeoutMillis;
    }

    @Generated
    public RetryExecutor(long timeoutMillis, long intervalMillis) {
        this.timeoutMillis = timeoutMillis;
        this.intervalMillis = intervalMillis;
    }
}

