/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.MySQLBaseBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.PlaceholderBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.ConnectInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.GlobalTableMapEventMapping;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.InternalResultSet;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.MySQLServerVersion;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.netty.MySQLBinlogEventPacketDecoder;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.netty.MySQLCommandPacketDecoder;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.netty.MySQLNegotiateHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.netty.MySQLNegotiatePackageDecoder;
import org.apache.shardingsphere.db.protocol.codec.DatabasePacketCodecEngine;
import org.apache.shardingsphere.db.protocol.codec.PacketCodec;
import org.apache.shardingsphere.db.protocol.mysql.codec.MySQLPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.netty.MySQLSequenceIdInboundHandler;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.binlog.MySQLComBinlogDumpCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.binlog.MySQLComRegisterSlaveCommandPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLErrPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.generic.MySQLOKPacket;
import org.apache.shardingsphere.db.protocol.netty.ChannelAttrInitializer;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.util.json.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLBinlogClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLBinlogClient.class);
    private final ConnectInfo connectInfo;
    private final boolean decodeWithTX;
    private final ArrayBlockingQueue<List<MySQLBaseBinlogEvent>> blockingEventQueue = new ArrayBlockingQueue(2500);
    private EventLoopGroup eventLoopGroup;
    private Channel channel;
    private Promise<Object> responseCallback;
    private MySQLServerVersion serverVersion;
    private volatile boolean running = true;

    public synchronized void connect() {
        this.eventLoopGroup = new NioEventLoopGroup(1);
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new ChannelAttrInitializer()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new PacketCodec((DatabasePacketCodecEngine)new MySQLPacketCodecEngine())});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLSequenceIdInboundHandler((Channel)socketChannel)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLNegotiatePackageDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLCommandPacketDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLNegotiateHandler(MySQLBinlogClient.this.connectInfo.getUsername(), MySQLBinlogClient.this.connectInfo.getPassword(), (Promise<Object>)MySQLBinlogClient.this.responseCallback)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new MySQLCommandResponseHandler()});
            }
        })).connect(this.connectInfo.getHost(), this.connectInfo.getPort()).channel();
        this.serverVersion = this.waitExpectedResponse(MySQLServerVersion.class).orElse(null);
        this.running = true;
    }

    public synchronized boolean execute(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.resetSequenceID();
        this.channel.writeAndFlush((Object)comQueryPacket);
        return this.waitExpectedResponse(MySQLOKPacket.class).isPresent();
    }

    public synchronized int executeUpdate(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.resetSequenceID();
        this.channel.writeAndFlush((Object)comQueryPacket);
        Optional<MySQLOKPacket> packet = this.waitExpectedResponse(MySQLOKPacket.class);
        if (!packet.isPresent()) {
            throw new PipelineInternalException("Could not get MySQL OK packet", new Object[0]);
        }
        return (int)packet.get().getAffectedRows();
    }

    public synchronized InternalResultSet executeQuery(String queryString) {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        MySQLComQueryPacket comQueryPacket = new MySQLComQueryPacket(queryString);
        this.resetSequenceID();
        this.channel.writeAndFlush((Object)comQueryPacket);
        Optional<InternalResultSet> result = this.waitExpectedResponse(InternalResultSet.class);
        if (!result.isPresent()) {
            throw new PipelineInternalException("Could not get MySQL FieldCount/ColumnDefinition/TextResultSetRow packet", new Object[0]);
        }
        return result.get();
    }

    public synchronized void subscribe(String binlogFileName, long binlogPosition) {
        this.initDumpConnectSession();
        this.registerSlave();
        this.dumpBinlog(binlogFileName, binlogPosition, this.queryChecksumLength());
        log.info("subscribe binlog file: {}, position: {}", (Object)binlogFileName, (Object)binlogPosition);
    }

    private void initDumpConnectSession() {
        if (this.serverVersion.greaterThanOrEqualTo(5, 6, 0)) {
            this.execute("SET @MASTER_BINLOG_CHECKSUM= @@GLOBAL.BINLOG_CHECKSUM");
        }
    }

    private void registerSlave() {
        this.responseCallback = new DefaultPromise((EventExecutor)this.eventLoopGroup.next());
        InetSocketAddress localAddress = (InetSocketAddress)this.channel.localAddress();
        MySQLComRegisterSlaveCommandPacket packet = new MySQLComRegisterSlaveCommandPacket(this.connectInfo.getServerId(), localAddress.getHostName(), this.connectInfo.getUsername(), this.connectInfo.getPassword(), localAddress.getPort());
        this.resetSequenceID();
        this.channel.writeAndFlush((Object)packet);
        this.waitExpectedResponse(MySQLOKPacket.class);
    }

    private int queryChecksumLength() {
        if (!this.serverVersion.greaterThanOrEqualTo(5, 6, 0)) {
            return 0;
        }
        InternalResultSet resultSet = this.executeQuery("SELECT @@GLOBAL.BINLOG_CHECKSUM");
        String checksumType = resultSet.getFieldValues().get(0).getData().iterator().next().toString();
        switch (checksumType.toUpperCase()) {
            case "NONE": {
                return 0;
            }
            case "CRC32": {
                return 4;
            }
        }
        throw new UnsupportedSQLOperationException(checksumType);
    }

    private void dumpBinlog(String binlogFileName, long binlogPosition, int checksumLength) {
        this.responseCallback = null;
        this.channel.pipeline().remove(MySQLCommandPacketDecoder.class);
        this.channel.pipeline().remove(MySQLCommandResponseHandler.class);
        String tableKey = String.join((CharSequence)":", this.connectInfo.getHost(), String.valueOf(this.connectInfo.getPort()));
        this.channel.pipeline().addLast(new ChannelHandler[]{new MySQLBinlogEventPacketDecoder(checksumLength, GlobalTableMapEventMapping.getTableMapEventMap(tableKey), this.decodeWithTX)});
        this.channel.pipeline().addLast(new ChannelHandler[]{new MySQLBinlogEventHandler(new PlaceholderBinlogEvent(binlogFileName, binlogPosition, 0L))});
        this.resetSequenceID();
        this.channel.writeAndFlush((Object)new MySQLComBinlogDumpCommandPacket((int)binlogPosition, this.connectInfo.getServerId(), binlogFileName));
    }

    private void resetSequenceID() {
        ((AtomicInteger)this.channel.attr(MySQLConstants.SEQUENCE_ID_ATTRIBUTE_KEY).get()).set(0);
    }

    public synchronized List<MySQLBaseBinlogEvent> poll() {
        if (!this.running) {
            return Collections.emptyList();
        }
        try {
            List<MySQLBaseBinlogEvent> result = this.blockingEventQueue.poll(100L, TimeUnit.MILLISECONDS);
            return null == result ? Collections.emptyList() : result;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
    }

    private <T> Optional<T> waitExpectedResponse(Class<T> type) {
        try {
            Object response = this.responseCallback.get(5L, TimeUnit.SECONDS);
            if (null == response) {
                return Optional.empty();
            }
            if (type.equals(response.getClass())) {
                return Optional.of(response);
            }
            if (response instanceof MySQLErrPacket) {
                throw new PipelineInternalException(((MySQLErrPacket)response).getErrorMessage(), new Object[0]);
            }
            throw new PipelineInternalException("unexpected response type", new Object[0]);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PipelineInternalException((Throwable)ex);
        }
        catch (ExecutionException | TimeoutException ex) {
            throw new PipelineInternalException((Throwable)ex);
        }
    }

    public Optional<ChannelFuture> closeChannel() {
        if (null == this.channel || !this.channel.isOpen()) {
            return Optional.empty();
        }
        this.running = false;
        ChannelFuture future = this.channel.close();
        if (null != this.eventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully();
        }
        return Optional.of(future);
    }

    @Generated
    public MySQLBinlogClient(ConnectInfo connectInfo, boolean decodeWithTX) {
        this.connectInfo = connectInfo;
        this.decodeWithTX = decodeWithTX;
    }

    private final class MySQLCommandResponseHandler
    extends ChannelInboundHandlerAdapter {
        private MySQLCommandResponseHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (null != MySQLBinlogClient.this.responseCallback) {
                MySQLBinlogClient.this.responseCallback.setSuccess(msg);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (null != MySQLBinlogClient.this.responseCallback) {
                MySQLBinlogClient.this.responseCallback.setFailure(cause);
                log.error("MySQLCommandResponseHandler protocol resolution error", cause);
            }
        }
    }

    private final class MySQLBinlogEventHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicReference<MySQLBaseBinlogEvent> lastBinlogEvent;
        private final AtomicBoolean reconnectRequested = new AtomicBoolean(false);

        MySQLBinlogEventHandler(MySQLBaseBinlogEvent lastBinlogEvent) {
            this.lastBinlogEvent = new AtomicReference<MySQLBaseBinlogEvent>(lastBinlogEvent);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!MySQLBinlogClient.this.running) {
                return;
            }
            if (msg instanceof List) {
                List records = (List)msg;
                if (records.isEmpty()) {
                    log.warn("The records is empty");
                    return;
                }
                this.lastBinlogEvent.set((MySQLBaseBinlogEvent)records.get(records.size() - 1));
                MySQLBinlogClient.this.blockingEventQueue.put(records);
                return;
            }
            if (msg instanceof MySQLBaseBinlogEvent) {
                this.lastBinlogEvent.set((MySQLBaseBinlogEvent)msg);
                MySQLBinlogClient.this.blockingEventQueue.put(Collections.singletonList(this.lastBinlogEvent.get()));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            log.warn("MySQL binlog channel inactive, channel: {}, running: {}", (Object)ctx.channel(), (Object)MySQLBinlogClient.this.running);
            if (!MySQLBinlogClient.this.running) {
                return;
            }
            this.tryReconnect();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            log.error("MySQLBinlogEventHandler protocol resolution error, channel: {}, lastBinlogEvent: {}", new Object[]{ctx.channel(), JsonUtils.toJsonString((Object)this.lastBinlogEvent.get()), cause});
        }

        private void tryReconnect() {
            if (this.reconnectRequested.compareAndSet(false, true)) {
                CompletableFuture.runAsync(this::reconnect).whenComplete((result, ex) -> this.reconnectRequested.set(false));
            }
        }

        private synchronized void reconnect() {
            for (int reconnectTimes = 0; reconnectTimes < 3; ++reconnectTimes) {
                try {
                    MySQLBinlogClient.this.connect();
                    log.info("Reconnect times {}", (Object)reconnectTimes);
                    MySQLBinlogClient.this.subscribe(this.lastBinlogEvent.get().getFileName(), this.lastBinlogEvent.get().getPosition());
                    break;
                }
                catch (RuntimeException ex) {
                    log.error("Reconnect failed, reconnect times: {}, lastBinlogEvent: {}", new Object[]{reconnectTimes, JsonUtils.toJsonString((Object)this.lastBinlogEvent.get()), ex});
                    ((Object)((Object)this)).wait(1000L << reconnectTimes);
                    continue;
                }
            }
        }
    }
}

