/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.postgresql.sqlbuilder.ddl.PostgreSQLDDLTemplateExecutor;

public final class PostgreSQLTablePropertiesLoader {
    private final String tableName;
    private final String schemaName;
    private final PostgreSQLDDLTemplateExecutor templateExecutor;

    public PostgreSQLTablePropertiesLoader(Connection connection, String tableName, String schemaName, int majorVersion, int minorVersion) {
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.templateExecutor = new PostgreSQLDDLTemplateExecutor(connection, majorVersion, minorVersion);
    }

    public Map<String, Object> load() throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.fetchDatabaseId());
        result.putAll(this.fetchSchemaId());
        result.putAll(this.fetchTableId());
        this.fetchTableProperties(result);
        return result;
    }

    private Map<String, Object> fetchDatabaseId() throws SQLException {
        Map<String, Object> params = Collections.singletonMap("databaseName", this.templateExecutor.getConnection().getCatalog());
        return this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_database_id.ftl");
    }

    private Map<String, Object> fetchSchemaId() {
        Map<String, Object> params = Collections.singletonMap("schemaName", this.schemaName);
        return this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_schema_id.ftl");
    }

    private Map<String, Object> fetchTableId() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2, 1.0f);
        params.put("schemaName", this.schemaName);
        params.put("tableName", this.tableName);
        return this.templateExecutor.executeByTemplateForSingleRow(params, "component/table/%s/get_table_id.ftl");
    }

    private void fetchTableProperties(Map<String, Object> context) throws SQLException {
        context.putAll(this.templateExecutor.executeByTemplateForSingleRow(context, "component/table/%s/properties.ftl"));
        this.updateAutoVacuumProperties(context);
        this.updateRlspolicySupport(context);
        this.templateExecutor.formatSecurityLabels(context);
    }

    private void updateAutoVacuumProperties(Map<String, Object> context) {
        context.put("autovacuum_enabled", this.getAutoVacuumEnabled(context.get("autovacuum_enabled")));
        context.put("toast_autovacuum_enabled", this.getAutoVacuumEnabled(context.get("toast_autovacuum_enabled")));
        context.put("autovacuum_custom", this.anyIsTrue(Arrays.asList(context.get("autovacuum_vacuum_threshold"), context.get("autovacuum_vacuum_scale_factor"), context.get("autovacuum_analyze_threshold"), context.get("autovacuum_analyze_scale_factor"), context.get("autovacuum_vacuum_cost_delay"), context.get("autovacuum_vacuum_cost_limit"), context.get("autovacuum_freeze_min_age"), context.get("autovacuum_freeze_max_age"), context.get("autovacuum_freeze_table_age"))) || "t".equals(context.get("autovacuum_enabled")) || "f".equals(context.get("autovacuum_enabled")));
        context.put("toast_autovacuum", this.anyIsTrue(Arrays.asList(context.get("toast_autovacuum_vacuum_threshold"), context.get("toast_autovacuum_vacuum_scale_factor"), context.get("toast_autovacuum_analyze_threshold"), context.get("toast_autovacuum_analyze_scale_factor"), context.get("toast_autovacuum_vacuum_cost_delay"), context.get("toast_autovacuum_vacuum_cost_limit"), context.get("toast_autovacuum_freeze_min_age"), context.get("toast_autovacuum_freeze_max_age"), context.get("toast_autovacuum_freeze_table_age"))) || "t".equals(context.get("toast_autovacuum_enabled")) || "f".equals(context.get("toast_autovacuum_enabled")));
    }

    private String getAutoVacuumEnabled(Object autoVacuumEnabled) {
        if (null == autoVacuumEnabled) {
            return "x";
        }
        if (Boolean.parseBoolean(autoVacuumEnabled.toString())) {
            return "t";
        }
        return "f";
    }

    private boolean anyIsTrue(Collection<Object> collection) {
        return collection.stream().anyMatch(each -> each instanceof Boolean && (Boolean)each != false);
    }

    private void updateRlspolicySupport(Map<String, Object> context) {
        if (context.containsKey("rlspolicy")) {
            if (context.get("rlspolicy") instanceof String && Boolean.parseBoolean(context.get("rlspolicy").toString())) {
                context.put("rlspolicy", true);
            }
            if (context.get("forcerlspolicy") instanceof String && Boolean.parseBoolean(context.get("forcerlspolicy").toString())) {
                context.put("forcerlspolicy", true);
            }
        }
    }
}

