/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.postgresql.packet.command;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.admin.PostgreSQLUnsupportedCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.PostgreSQLAggregatedCommandPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.bind.PostgreSQLComBindPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.close.PostgreSQLComClosePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.describe.PostgreSQLComDescribePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.execute.PostgreSQLComExecutePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.flush.PostgreSQLComFlushPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.parse.PostgreSQLComParsePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.extended.sync.PostgreSQLComSyncPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.command.query.simple.PostgreSQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLComTerminationPacket;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLCommandPacketFactory {
    public static PostgreSQLCommandPacket newInstance(PostgreSQLCommandPacketType commandPacketType, PostgreSQLPacketPayload payload) {
        if (!PostgreSQLCommandPacketType.isExtendedProtocolPacketType(commandPacketType)) {
            payload.getByteBuf().skipBytes(1);
            return PostgreSQLCommandPacketFactory.getPostgreSQLCommandPacket(commandPacketType, payload);
        }
        ArrayList<PostgreSQLCommandPacket> result = new ArrayList<PostgreSQLCommandPacket>();
        while (payload.hasCompletePacket()) {
            PostgreSQLCommandPacketType type = PostgreSQLCommandPacketType.valueOf(payload.readInt1());
            int length = payload.getByteBuf().getInt(payload.getByteBuf().readerIndex());
            PostgreSQLPacketPayload slicedPayload = new PostgreSQLPacketPayload(payload.getByteBuf().readSlice(length), payload.getCharset());
            result.add(PostgreSQLCommandPacketFactory.getPostgreSQLCommandPacket(type, slicedPayload));
        }
        return new PostgreSQLAggregatedCommandPacket(result);
    }

    private static PostgreSQLCommandPacket getPostgreSQLCommandPacket(PostgreSQLCommandPacketType commandPacketType, PostgreSQLPacketPayload payload) {
        switch (commandPacketType) {
            case SIMPLE_QUERY: {
                return new PostgreSQLComQueryPacket(payload);
            }
            case PARSE_COMMAND: {
                return new PostgreSQLComParsePacket(payload);
            }
            case BIND_COMMAND: {
                return new PostgreSQLComBindPacket(payload);
            }
            case DESCRIBE_COMMAND: {
                return new PostgreSQLComDescribePacket(payload);
            }
            case EXECUTE_COMMAND: {
                return new PostgreSQLComExecutePacket(payload);
            }
            case SYNC_COMMAND: {
                return new PostgreSQLComSyncPacket(payload);
            }
            case CLOSE_COMMAND: {
                return new PostgreSQLComClosePacket(payload);
            }
            case FLUSH_COMMAND: {
                return new PostgreSQLComFlushPacket(payload);
            }
            case TERMINATE: {
                return new PostgreSQLComTerminationPacket(payload);
            }
        }
        return new PostgreSQLUnsupportedCommandPacket(commandPacketType);
    }

    @Generated
    private PostgreSQLCommandPacketFactory() {
    }
}

