/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.internal.data;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.concurrent.Immutable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.AttributeUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SpanLimits;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.internal.data.AutoValue_ImmutableExceptionEventData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;

@AutoValue
@Immutable
abstract class ImmutableExceptionEventData
implements ExceptionEventData {
    private static final AttributeKey<String> EXCEPTION_TYPE = AttributeKey.stringKey("exception.type");
    private static final AttributeKey<String> EXCEPTION_MESSAGE = AttributeKey.stringKey("exception.message");
    private static final AttributeKey<String> EXCEPTION_STACKTRACE = AttributeKey.stringKey("exception.stacktrace");
    private static final String EXCEPTION_EVENT_NAME = "exception";

    static ExceptionEventData create(SpanLimits spanLimits, long epochNanos, Throwable exception, Attributes additionalAttributes) {
        return new AutoValue_ImmutableExceptionEventData(epochNanos, exception, additionalAttributes, spanLimits);
    }

    ImmutableExceptionEventData() {
    }

    protected abstract SpanLimits getSpanLimits();

    @Override
    public final String getName() {
        return EXCEPTION_EVENT_NAME;
    }

    @Override
    @Memoized
    public Attributes getAttributes() {
        Throwable exception = this.getException();
        Attributes additionalAttributes = this.getAdditionalAttributes();
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(EXCEPTION_TYPE, exception.getClass().getCanonicalName());
        String message = exception.getMessage();
        if (message != null) {
            attributesBuilder.put(EXCEPTION_MESSAGE, message);
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            exception.printStackTrace(printWriter);
        }
        attributesBuilder.put(EXCEPTION_STACKTRACE, stringWriter.toString());
        attributesBuilder.putAll(additionalAttributes);
        SpanLimits spanLimits = this.getSpanLimits();
        return AttributeUtil.applyAttributesLimit(attributesBuilder.build(), spanLimits.getMaxNumberOfAttributesPerEvent(), spanLimits.getMaxAttributeValueLength());
    }

    @Override
    public final int getTotalAttributeCount() {
        return this.getAttributes().size();
    }
}

